/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.InputCompressionType;
import software.amazon.awssdk.services.dynamodb.model.InputFormat;
import software.amazon.awssdk.services.dynamodb.model.InputFormatOptions;
import software.amazon.awssdk.services.dynamodb.model.S3BucketSource;
import software.amazon.awssdk.services.dynamodb.model.TableCreationParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportTableRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, ImportTableRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(ImportTableRequest.getter(ImportTableRequest::clientToken)).setter(ImportTableRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<S3BucketSource> S3_BUCKET_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3BucketSource").getter(ImportTableRequest.getter(ImportTableRequest::s3BucketSource)).setter(ImportTableRequest.setter(Builder::s3BucketSource)).constructor(S3BucketSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketSource").build()}).build();
    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputFormat").getter(ImportTableRequest.getter(ImportTableRequest::inputFormatAsString)).setter(ImportTableRequest.setter(Builder::inputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()}).build();
    private static final SdkField<InputFormatOptions> INPUT_FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputFormatOptions").getter(ImportTableRequest.getter(ImportTableRequest::inputFormatOptions)).setter(ImportTableRequest.setter(Builder::inputFormatOptions)).constructor(InputFormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormatOptions").build()}).build();
    private static final SdkField<String> INPUT_COMPRESSION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputCompressionType").getter(ImportTableRequest.getter(ImportTableRequest::inputCompressionTypeAsString)).setter(ImportTableRequest.setter(Builder::inputCompressionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputCompressionType").build()}).build();
    private static final SdkField<TableCreationParameters> TABLE_CREATION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TableCreationParameters").getter(ImportTableRequest.getter(ImportTableRequest::tableCreationParameters)).setter(ImportTableRequest.setter(Builder::tableCreationParameters)).constructor(TableCreationParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableCreationParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, S3_BUCKET_SOURCE_FIELD, INPUT_FORMAT_FIELD, INPUT_FORMAT_OPTIONS_FIELD, INPUT_COMPRESSION_TYPE_FIELD, TABLE_CREATION_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("S3BucketSource", S3_BUCKET_SOURCE_FIELD);
            this.put("InputFormat", INPUT_FORMAT_FIELD);
            this.put("InputFormatOptions", INPUT_FORMAT_OPTIONS_FIELD);
            this.put("InputCompressionType", INPUT_COMPRESSION_TYPE_FIELD);
            this.put("TableCreationParameters", TABLE_CREATION_PARAMETERS_FIELD);
        }
    });
    private final String clientToken;
    private final S3BucketSource s3BucketSource;
    private final String inputFormat;
    private final InputFormatOptions inputFormatOptions;
    private final String inputCompressionType;
    private final TableCreationParameters tableCreationParameters;

    private ImportTableRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.s3BucketSource = builder.s3BucketSource;
        this.inputFormat = builder.inputFormat;
        this.inputFormatOptions = builder.inputFormatOptions;
        this.inputCompressionType = builder.inputCompressionType;
        this.tableCreationParameters = builder.tableCreationParameters;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final S3BucketSource s3BucketSource() {
        return this.s3BucketSource;
    }

    public final InputFormat inputFormat() {
        return InputFormat.fromValue(this.inputFormat);
    }

    public final String inputFormatAsString() {
        return this.inputFormat;
    }

    public final InputFormatOptions inputFormatOptions() {
        return this.inputFormatOptions;
    }

    public final InputCompressionType inputCompressionType() {
        return InputCompressionType.fromValue(this.inputCompressionType);
    }

    public final String inputCompressionTypeAsString() {
        return this.inputCompressionType;
    }

    public final TableCreationParameters tableCreationParameters() {
        return this.tableCreationParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFormatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputCompressionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableCreationParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTableRequest)) {
            return false;
        }
        ImportTableRequest other = (ImportTableRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.s3BucketSource(), other.s3BucketSource()) && Objects.equals(this.inputFormatAsString(), other.inputFormatAsString()) && Objects.equals(this.inputFormatOptions(), other.inputFormatOptions()) && Objects.equals(this.inputCompressionTypeAsString(), other.inputCompressionTypeAsString()) && Objects.equals(this.tableCreationParameters(), other.tableCreationParameters());
    }

    public final String toString() {
        return ToString.builder((String)"ImportTableRequest").add("ClientToken", (Object)this.clientToken()).add("S3BucketSource", (Object)this.s3BucketSource()).add("InputFormat", (Object)this.inputFormatAsString()).add("InputFormatOptions", (Object)this.inputFormatOptions()).add("InputCompressionType", (Object)this.inputCompressionTypeAsString()).add("TableCreationParameters", (Object)this.tableCreationParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "S3BucketSource": {
                return Optional.ofNullable(clazz.cast(this.s3BucketSource()));
            }
            case "InputFormat": {
                return Optional.ofNullable(clazz.cast(this.inputFormatAsString()));
            }
            case "InputFormatOptions": {
                return Optional.ofNullable(clazz.cast(this.inputFormatOptions()));
            }
            case "InputCompressionType": {
                return Optional.ofNullable(clazz.cast(this.inputCompressionTypeAsString()));
            }
            case "TableCreationParameters": {
                return Optional.ofNullable(clazz.cast(this.tableCreationParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportTableRequest, T> g) {
        return obj -> g.apply((ImportTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private S3BucketSource s3BucketSource;
        private String inputFormat;
        private InputFormatOptions inputFormatOptions;
        private String inputCompressionType;
        private TableCreationParameters tableCreationParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTableRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.s3BucketSource(model.s3BucketSource);
            this.inputFormat(model.inputFormat);
            this.inputFormatOptions(model.inputFormatOptions);
            this.inputCompressionType(model.inputCompressionType);
            this.tableCreationParameters(model.tableCreationParameters);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final S3BucketSource.Builder getS3BucketSource() {
            return this.s3BucketSource != null ? this.s3BucketSource.toBuilder() : null;
        }

        public final void setS3BucketSource(S3BucketSource.BuilderImpl s3BucketSource) {
            this.s3BucketSource = s3BucketSource != null ? s3BucketSource.build() : null;
        }

        @Override
        public final Builder s3BucketSource(S3BucketSource s3BucketSource) {
            this.s3BucketSource = s3BucketSource;
            return this;
        }

        public final String getInputFormat() {
            return this.inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        public final InputFormatOptions.Builder getInputFormatOptions() {
            return this.inputFormatOptions != null ? this.inputFormatOptions.toBuilder() : null;
        }

        public final void setInputFormatOptions(InputFormatOptions.BuilderImpl inputFormatOptions) {
            this.inputFormatOptions = inputFormatOptions != null ? inputFormatOptions.build() : null;
        }

        @Override
        public final Builder inputFormatOptions(InputFormatOptions inputFormatOptions) {
            this.inputFormatOptions = inputFormatOptions;
            return this;
        }

        public final String getInputCompressionType() {
            return this.inputCompressionType;
        }

        public final void setInputCompressionType(String inputCompressionType) {
            this.inputCompressionType = inputCompressionType;
        }

        @Override
        public final Builder inputCompressionType(String inputCompressionType) {
            this.inputCompressionType = inputCompressionType;
            return this;
        }

        @Override
        public final Builder inputCompressionType(InputCompressionType inputCompressionType) {
            this.inputCompressionType(inputCompressionType == null ? null : inputCompressionType.toString());
            return this;
        }

        public final TableCreationParameters.Builder getTableCreationParameters() {
            return this.tableCreationParameters != null ? this.tableCreationParameters.toBuilder() : null;
        }

        public final void setTableCreationParameters(TableCreationParameters.BuilderImpl tableCreationParameters) {
            this.tableCreationParameters = tableCreationParameters != null ? tableCreationParameters.build() : null;
        }

        @Override
        public final Builder tableCreationParameters(TableCreationParameters tableCreationParameters) {
            this.tableCreationParameters = tableCreationParameters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportTableRequest build() {
            return new ImportTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ImportTableRequest> {
        public Builder clientToken(String var1);

        public Builder s3BucketSource(S3BucketSource var1);

        default public Builder s3BucketSource(Consumer<S3BucketSource.Builder> s3BucketSource) {
            return this.s3BucketSource((S3BucketSource)((S3BucketSource.Builder)S3BucketSource.builder().applyMutation(s3BucketSource)).build());
        }

        public Builder inputFormat(String var1);

        public Builder inputFormat(InputFormat var1);

        public Builder inputFormatOptions(InputFormatOptions var1);

        default public Builder inputFormatOptions(Consumer<InputFormatOptions.Builder> inputFormatOptions) {
            return this.inputFormatOptions((InputFormatOptions)((InputFormatOptions.Builder)InputFormatOptions.builder().applyMutation(inputFormatOptions)).build());
        }

        public Builder inputCompressionType(String var1);

        public Builder inputCompressionType(InputCompressionType var1);

        public Builder tableCreationParameters(TableCreationParameters var1);

        default public Builder tableCreationParameters(Consumer<TableCreationParameters.Builder> tableCreationParameters) {
            return this.tableCreationParameters((TableCreationParameters)((TableCreationParameters.Builder)TableCreationParameters.builder().applyMutation(tableCreationParameters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

