/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.ContributorInsightsAction;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateContributorInsightsRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, UpdateContributorInsightsRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(UpdateContributorInsightsRequest.getter(UpdateContributorInsightsRequest::tableName)).setter(UpdateContributorInsightsRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexName").getter(UpdateContributorInsightsRequest.getter(UpdateContributorInsightsRequest::indexName)).setter(UpdateContributorInsightsRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<String> CONTRIBUTOR_INSIGHTS_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContributorInsightsAction").getter(UpdateContributorInsightsRequest.getter(UpdateContributorInsightsRequest::contributorInsightsActionAsString)).setter(UpdateContributorInsightsRequest.setter(Builder::contributorInsightsAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributorInsightsAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, INDEX_NAME_FIELD, CONTRIBUTOR_INSIGHTS_ACTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TableName", TABLE_NAME_FIELD);
            this.put("IndexName", INDEX_NAME_FIELD);
            this.put("ContributorInsightsAction", CONTRIBUTOR_INSIGHTS_ACTION_FIELD);
        }
    });
    private final String tableName;
    private final String indexName;
    private final String contributorInsightsAction;

    private UpdateContributorInsightsRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.contributorInsightsAction = builder.contributorInsightsAction;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String indexName() {
        return this.indexName;
    }

    public final ContributorInsightsAction contributorInsightsAction() {
        return ContributorInsightsAction.fromValue(this.contributorInsightsAction);
    }

    public final String contributorInsightsActionAsString() {
        return this.contributorInsightsAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contributorInsightsActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateContributorInsightsRequest)) {
            return false;
        }
        UpdateContributorInsightsRequest other = (UpdateContributorInsightsRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.contributorInsightsActionAsString(), other.contributorInsightsActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateContributorInsightsRequest").add("TableName", (Object)this.tableName()).add("IndexName", (Object)this.indexName()).add("ContributorInsightsAction", (Object)this.contributorInsightsActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "ContributorInsightsAction": {
                return Optional.ofNullable(clazz.cast(this.contributorInsightsActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateContributorInsightsRequest, T> g) {
        return obj -> g.apply((UpdateContributorInsightsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private String indexName;
        private String contributorInsightsAction;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateContributorInsightsRequest model) {
            super(model);
            this.tableName(model.tableName);
            this.indexName(model.indexName);
            this.contributorInsightsAction(model.contributorInsightsAction);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final String getContributorInsightsAction() {
            return this.contributorInsightsAction;
        }

        public final void setContributorInsightsAction(String contributorInsightsAction) {
            this.contributorInsightsAction = contributorInsightsAction;
        }

        @Override
        public final Builder contributorInsightsAction(String contributorInsightsAction) {
            this.contributorInsightsAction = contributorInsightsAction;
            return this;
        }

        @Override
        public final Builder contributorInsightsAction(ContributorInsightsAction contributorInsightsAction) {
            this.contributorInsightsAction(contributorInsightsAction == null ? null : contributorInsightsAction.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateContributorInsightsRequest build() {
            return new UpdateContributorInsightsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateContributorInsightsRequest> {
        public Builder tableName(String var1);

        public Builder indexName(String var1);

        public Builder contributorInsightsAction(String var1);

        public Builder contributorInsightsAction(ContributorInsightsAction var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

