/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKinesisStreamingDestinationRequest extends DynamoDbRequest implements
        ToCopyableBuilder<UpdateKinesisStreamingDestinationRequest.Builder, UpdateKinesisStreamingDestinationRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(UpdateKinesisStreamingDestinationRequest::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(UpdateKinesisStreamingDestinationRequest::streamArn))
            .setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<UpdateKinesisStreamingConfiguration> UPDATE_KINESIS_STREAMING_CONFIGURATION_FIELD = SdkField
            .<UpdateKinesisStreamingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("UpdateKinesisStreamingConfiguration")
            .getter(getter(UpdateKinesisStreamingDestinationRequest::updateKinesisStreamingConfiguration))
            .setter(setter(Builder::updateKinesisStreamingConfiguration))
            .constructor(UpdateKinesisStreamingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UpdateKinesisStreamingConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD,
            STREAM_ARN_FIELD, UPDATE_KINESIS_STREAMING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("TableName", TABLE_NAME_FIELD);
                    put("StreamArn", STREAM_ARN_FIELD);
                    put("UpdateKinesisStreamingConfiguration", UPDATE_KINESIS_STREAMING_CONFIGURATION_FIELD);
                }
            });

    private final String tableName;

    private final String streamArn;

    private final UpdateKinesisStreamingConfiguration updateKinesisStreamingConfiguration;

    private UpdateKinesisStreamingDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.streamArn = builder.streamArn;
        this.updateKinesisStreamingConfiguration = builder.updateKinesisStreamingConfiguration;
    }

    /**
     * <p>
     * The table name for the Kinesis streaming destination input. You can also provide the ARN of the table in this
     * parameter.
     * </p>
     * 
     * @return The table name for the Kinesis streaming destination input. You can also provide the ARN of the table in
     *         this parameter.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the Kinesis stream input.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the Kinesis stream input.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The command to update the Kinesis stream configuration.
     * </p>
     * 
     * @return The command to update the Kinesis stream configuration.
     */
    public final UpdateKinesisStreamingConfiguration updateKinesisStreamingConfiguration() {
        return updateKinesisStreamingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(updateKinesisStreamingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKinesisStreamingDestinationRequest)) {
            return false;
        }
        UpdateKinesisStreamingDestinationRequest other = (UpdateKinesisStreamingDestinationRequest) obj;
        return Objects.equals(tableName(), other.tableName()) && Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(updateKinesisStreamingConfiguration(), other.updateKinesisStreamingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKinesisStreamingDestinationRequest").add("TableName", tableName())
                .add("StreamArn", streamArn()).add("UpdateKinesisStreamingConfiguration", updateKinesisStreamingConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "UpdateKinesisStreamingConfiguration":
            return Optional.ofNullable(clazz.cast(updateKinesisStreamingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKinesisStreamingDestinationRequest, T> g) {
        return obj -> g.apply((UpdateKinesisStreamingDestinationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DynamoDbRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateKinesisStreamingDestinationRequest> {
        /**
         * <p>
         * The table name for the Kinesis streaming destination input. You can also provide the ARN of the table in this
         * parameter.
         * </p>
         * 
         * @param tableName
         *        The table name for the Kinesis streaming destination input. You can also provide the ARN of the table
         *        in this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the Kinesis stream input.
         * </p>
         * 
         * @param streamArn
         *        The Amazon Resource Name (ARN) for the Kinesis stream input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The command to update the Kinesis stream configuration.
         * </p>
         * 
         * @param updateKinesisStreamingConfiguration
         *        The command to update the Kinesis stream configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateKinesisStreamingConfiguration(UpdateKinesisStreamingConfiguration updateKinesisStreamingConfiguration);

        /**
         * <p>
         * The command to update the Kinesis stream configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateKinesisStreamingConfiguration.Builder} avoiding the need to create one manually via
         * {@link UpdateKinesisStreamingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateKinesisStreamingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #updateKinesisStreamingConfiguration(UpdateKinesisStreamingConfiguration)}.
         * 
         * @param updateKinesisStreamingConfiguration
         *        a consumer that will call methods on {@link UpdateKinesisStreamingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateKinesisStreamingConfiguration(UpdateKinesisStreamingConfiguration)
         */
        default Builder updateKinesisStreamingConfiguration(
                Consumer<UpdateKinesisStreamingConfiguration.Builder> updateKinesisStreamingConfiguration) {
            return updateKinesisStreamingConfiguration(UpdateKinesisStreamingConfiguration.builder()
                    .applyMutation(updateKinesisStreamingConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DynamoDbRequest.BuilderImpl implements Builder {
        private String tableName;

        private String streamArn;

        private UpdateKinesisStreamingConfiguration updateKinesisStreamingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKinesisStreamingDestinationRequest model) {
            super(model);
            tableName(model.tableName);
            streamArn(model.streamArn);
            updateKinesisStreamingConfiguration(model.updateKinesisStreamingConfiguration);
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final UpdateKinesisStreamingConfiguration.Builder getUpdateKinesisStreamingConfiguration() {
            return updateKinesisStreamingConfiguration != null ? updateKinesisStreamingConfiguration.toBuilder() : null;
        }

        public final void setUpdateKinesisStreamingConfiguration(
                UpdateKinesisStreamingConfiguration.BuilderImpl updateKinesisStreamingConfiguration) {
            this.updateKinesisStreamingConfiguration = updateKinesisStreamingConfiguration != null ? updateKinesisStreamingConfiguration
                    .build() : null;
        }

        @Override
        public final Builder updateKinesisStreamingConfiguration(
                UpdateKinesisStreamingConfiguration updateKinesisStreamingConfiguration) {
            this.updateKinesisStreamingConfiguration = updateKinesisStreamingConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKinesisStreamingDestinationRequest build() {
            return new UpdateKinesisStreamingDestinationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
