/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an item to be retrieved as part of the transaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactGetItem implements SdkPojo, Serializable, ToCopyableBuilder<TransactGetItem.Builder, TransactGetItem> {
    private static final SdkField<Get> GET_FIELD = SdkField.<Get> builder(MarshallingType.SDK_POJO).memberName("Get")
            .getter(getter(TransactGetItem::get)).setter(setter(Builder::get)).constructor(Get::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Get").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("Get", GET_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Get get;

    private TransactGetItem(BuilderImpl builder) {
        this.get = builder.get;
    }

    /**
     * <p>
     * Contains the primary key that identifies the item to get, together with the name of the table that contains the
     * item, and optionally the specific attributes of the item to retrieve.
     * </p>
     * 
     * @return Contains the primary key that identifies the item to get, together with the name of the table that
     *         contains the item, and optionally the specific attributes of the item to retrieve.
     */
    public final Get get() {
        return get;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(get());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactGetItem)) {
            return false;
        }
        TransactGetItem other = (TransactGetItem) obj;
        return Objects.equals(get(), other.get());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransactGetItem").add("Get", get()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Get":
            return Optional.ofNullable(clazz.cast(get()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TransactGetItem, T> g) {
        return obj -> g.apply((TransactGetItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransactGetItem> {
        /**
         * <p>
         * Contains the primary key that identifies the item to get, together with the name of the table that contains
         * the item, and optionally the specific attributes of the item to retrieve.
         * </p>
         * 
         * @param get
         *        Contains the primary key that identifies the item to get, together with the name of the table that
         *        contains the item, and optionally the specific attributes of the item to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder get(Get get);

        /**
         * <p>
         * Contains the primary key that identifies the item to get, together with the name of the table that contains
         * the item, and optionally the specific attributes of the item to retrieve.
         * </p>
         * This is a convenience method that creates an instance of the {@link Get.Builder} avoiding the need to create
         * one manually via {@link Get#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Get.Builder#build()} is called immediately and its result is
         * passed to {@link #get(Get)}.
         * 
         * @param get
         *        a consumer that will call methods on {@link Get.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #get(Get)
         */
        default Builder get(Consumer<Get.Builder> get) {
            return get(Get.builder().applyMutation(get).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Get get;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactGetItem model) {
            get(model.get);
        }

        public final Get.Builder getGet() {
            return get != null ? get.toBuilder() : null;
        }

        public final void setGet(Get.BuilderImpl get) {
            this.get = get != null ? get.build() : null;
        }

        @Override
        public final Builder get(Get get) {
            this.get = get;
            return this;
        }

        @Override
        public TransactGetItem build() {
            return new TransactGetItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
