/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Kinesis data stream destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisDataStreamDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisDataStreamDestination.Builder, KinesisDataStreamDestination> {
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamArn").getter(getter(KinesisDataStreamDestination::streamArn)).setter(setter(Builder::streamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()).build();

    private static final SdkField<String> DESTINATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationStatus").getter(getter(KinesisDataStreamDestination::destinationStatusAsString))
            .setter(setter(Builder::destinationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatus").build()).build();

    private static final SdkField<String> DESTINATION_STATUS_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DestinationStatusDescription")
            .getter(getter(KinesisDataStreamDestination::destinationStatusDescription))
            .setter(setter(Builder::destinationStatusDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatusDescription")
                    .build()).build();

    private static final SdkField<String> APPROXIMATE_CREATION_DATE_TIME_PRECISION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApproximateCreationDateTimePrecision")
            .getter(getter(KinesisDataStreamDestination::approximateCreationDateTimePrecisionAsString))
            .setter(setter(Builder::approximateCreationDateTimePrecision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ApproximateCreationDateTimePrecision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_ARN_FIELD,
            DESTINATION_STATUS_FIELD, DESTINATION_STATUS_DESCRIPTION_FIELD, APPROXIMATE_CREATION_DATE_TIME_PRECISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StreamArn", STREAM_ARN_FIELD);
                    put("DestinationStatus", DESTINATION_STATUS_FIELD);
                    put("DestinationStatusDescription", DESTINATION_STATUS_DESCRIPTION_FIELD);
                    put("ApproximateCreationDateTimePrecision", APPROXIMATE_CREATION_DATE_TIME_PRECISION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String streamArn;

    private final String destinationStatus;

    private final String destinationStatusDescription;

    private final String approximateCreationDateTimePrecision;

    private KinesisDataStreamDestination(BuilderImpl builder) {
        this.streamArn = builder.streamArn;
        this.destinationStatus = builder.destinationStatus;
        this.destinationStatusDescription = builder.destinationStatusDescription;
        this.approximateCreationDateTimePrecision = builder.approximateCreationDateTimePrecision;
    }

    /**
     * <p>
     * The ARN for a specific Kinesis data stream.
     * </p>
     * 
     * @return The ARN for a specific Kinesis data stream.
     */
    public final String streamArn() {
        return streamArn;
    }

    /**
     * <p>
     * The current status of replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationStatus}
     * will return {@link DestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationStatusAsString}.
     * </p>
     * 
     * @return The current status of replication.
     * @see DestinationStatus
     */
    public final DestinationStatus destinationStatus() {
        return DestinationStatus.fromValue(destinationStatus);
    }

    /**
     * <p>
     * The current status of replication.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #destinationStatus}
     * will return {@link DestinationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #destinationStatusAsString}.
     * </p>
     * 
     * @return The current status of replication.
     * @see DestinationStatus
     */
    public final String destinationStatusAsString() {
        return destinationStatus;
    }

    /**
     * <p>
     * The human-readable string that corresponds to the replica status.
     * </p>
     * 
     * @return The human-readable string that corresponds to the replica status.
     */
    public final String destinationStatusDescription() {
        return destinationStatusDescription;
    }

    /**
     * <p>
     * The precision of the Kinesis data stream timestamp. The values are either <code>MILLISECOND</code> or
     * <code>MICROSECOND</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approximateCreationDateTimePrecision} will return
     * {@link ApproximateCreationDateTimePrecision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #approximateCreationDateTimePrecisionAsString}.
     * </p>
     * 
     * @return The precision of the Kinesis data stream timestamp. The values are either <code>MILLISECOND</code> or
     *         <code>MICROSECOND</code>.
     * @see ApproximateCreationDateTimePrecision
     */
    public final ApproximateCreationDateTimePrecision approximateCreationDateTimePrecision() {
        return ApproximateCreationDateTimePrecision.fromValue(approximateCreationDateTimePrecision);
    }

    /**
     * <p>
     * The precision of the Kinesis data stream timestamp. The values are either <code>MILLISECOND</code> or
     * <code>MICROSECOND</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approximateCreationDateTimePrecision} will return
     * {@link ApproximateCreationDateTimePrecision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #approximateCreationDateTimePrecisionAsString}.
     * </p>
     * 
     * @return The precision of the Kinesis data stream timestamp. The values are either <code>MILLISECOND</code> or
     *         <code>MICROSECOND</code>.
     * @see ApproximateCreationDateTimePrecision
     */
    public final String approximateCreationDateTimePrecisionAsString() {
        return approximateCreationDateTimePrecision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationStatusDescription());
        hashCode = 31 * hashCode + Objects.hashCode(approximateCreationDateTimePrecisionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisDataStreamDestination)) {
            return false;
        }
        KinesisDataStreamDestination other = (KinesisDataStreamDestination) obj;
        return Objects.equals(streamArn(), other.streamArn())
                && Objects.equals(destinationStatusAsString(), other.destinationStatusAsString())
                && Objects.equals(destinationStatusDescription(), other.destinationStatusDescription())
                && Objects.equals(approximateCreationDateTimePrecisionAsString(),
                        other.approximateCreationDateTimePrecisionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisDataStreamDestination").add("StreamArn", streamArn())
                .add("DestinationStatus", destinationStatusAsString())
                .add("DestinationStatusDescription", destinationStatusDescription())
                .add("ApproximateCreationDateTimePrecision", approximateCreationDateTimePrecisionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamArn":
            return Optional.ofNullable(clazz.cast(streamArn()));
        case "DestinationStatus":
            return Optional.ofNullable(clazz.cast(destinationStatusAsString()));
        case "DestinationStatusDescription":
            return Optional.ofNullable(clazz.cast(destinationStatusDescription()));
        case "ApproximateCreationDateTimePrecision":
            return Optional.ofNullable(clazz.cast(approximateCreationDateTimePrecisionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<KinesisDataStreamDestination, T> g) {
        return obj -> g.apply((KinesisDataStreamDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisDataStreamDestination> {
        /**
         * <p>
         * The ARN for a specific Kinesis data stream.
         * </p>
         * 
         * @param streamArn
         *        The ARN for a specific Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamArn(String streamArn);

        /**
         * <p>
         * The current status of replication.
         * </p>
         * 
         * @param destinationStatus
         *        The current status of replication.
         * @see DestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationStatus
         */
        Builder destinationStatus(String destinationStatus);

        /**
         * <p>
         * The current status of replication.
         * </p>
         * 
         * @param destinationStatus
         *        The current status of replication.
         * @see DestinationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DestinationStatus
         */
        Builder destinationStatus(DestinationStatus destinationStatus);

        /**
         * <p>
         * The human-readable string that corresponds to the replica status.
         * </p>
         * 
         * @param destinationStatusDescription
         *        The human-readable string that corresponds to the replica status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationStatusDescription(String destinationStatusDescription);

        /**
         * <p>
         * The precision of the Kinesis data stream timestamp. The values are either <code>MILLISECOND</code> or
         * <code>MICROSECOND</code>.
         * </p>
         * 
         * @param approximateCreationDateTimePrecision
         *        The precision of the Kinesis data stream timestamp. The values are either <code>MILLISECOND</code> or
         *        <code>MICROSECOND</code>.
         * @see ApproximateCreationDateTimePrecision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApproximateCreationDateTimePrecision
         */
        Builder approximateCreationDateTimePrecision(String approximateCreationDateTimePrecision);

        /**
         * <p>
         * The precision of the Kinesis data stream timestamp. The values are either <code>MILLISECOND</code> or
         * <code>MICROSECOND</code>.
         * </p>
         * 
         * @param approximateCreationDateTimePrecision
         *        The precision of the Kinesis data stream timestamp. The values are either <code>MILLISECOND</code> or
         *        <code>MICROSECOND</code>.
         * @see ApproximateCreationDateTimePrecision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApproximateCreationDateTimePrecision
         */
        Builder approximateCreationDateTimePrecision(ApproximateCreationDateTimePrecision approximateCreationDateTimePrecision);
    }

    static final class BuilderImpl implements Builder {
        private String streamArn;

        private String destinationStatus;

        private String destinationStatusDescription;

        private String approximateCreationDateTimePrecision;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisDataStreamDestination model) {
            streamArn(model.streamArn);
            destinationStatus(model.destinationStatus);
            destinationStatusDescription(model.destinationStatusDescription);
            approximateCreationDateTimePrecision(model.approximateCreationDateTimePrecision);
        }

        public final String getStreamArn() {
            return streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getDestinationStatus() {
            return destinationStatus;
        }

        public final void setDestinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
        }

        @Override
        public final Builder destinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
            return this;
        }

        @Override
        public final Builder destinationStatus(DestinationStatus destinationStatus) {
            this.destinationStatus(destinationStatus == null ? null : destinationStatus.toString());
            return this;
        }

        public final String getDestinationStatusDescription() {
            return destinationStatusDescription;
        }

        public final void setDestinationStatusDescription(String destinationStatusDescription) {
            this.destinationStatusDescription = destinationStatusDescription;
        }

        @Override
        public final Builder destinationStatusDescription(String destinationStatusDescription) {
            this.destinationStatusDescription = destinationStatusDescription;
            return this;
        }

        public final String getApproximateCreationDateTimePrecision() {
            return approximateCreationDateTimePrecision;
        }

        public final void setApproximateCreationDateTimePrecision(String approximateCreationDateTimePrecision) {
            this.approximateCreationDateTimePrecision = approximateCreationDateTimePrecision;
        }

        @Override
        public final Builder approximateCreationDateTimePrecision(String approximateCreationDateTimePrecision) {
            this.approximateCreationDateTimePrecision = approximateCreationDateTimePrecision;
            return this;
        }

        @Override
        public final Builder approximateCreationDateTimePrecision(
                ApproximateCreationDateTimePrecision approximateCreationDateTimePrecision) {
            this.approximateCreationDateTimePrecision(approximateCreationDateTimePrecision == null ? null
                    : approximateCreationDateTimePrecision.toString());
            return this;
        }

        @Override
        public KinesisDataStreamDestination build() {
            return new KinesisDataStreamDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
