/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details of a table archival operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchivalSummary implements SdkPojo, Serializable, ToCopyableBuilder<ArchivalSummary.Builder, ArchivalSummary> {
    private static final SdkField<Instant> ARCHIVAL_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ArchivalDateTime").getter(getter(ArchivalSummary::archivalDateTime))
            .setter(setter(Builder::archivalDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivalDateTime").build()).build();

    private static final SdkField<String> ARCHIVAL_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchivalReason").getter(getter(ArchivalSummary::archivalReason)).setter(setter(Builder::archivalReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivalReason").build()).build();

    private static final SdkField<String> ARCHIVAL_BACKUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchivalBackupArn").getter(getter(ArchivalSummary::archivalBackupArn))
            .setter(setter(Builder::archivalBackupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchivalBackupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVAL_DATE_TIME_FIELD,
            ARCHIVAL_REASON_FIELD, ARCHIVAL_BACKUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("ArchivalDateTime", ARCHIVAL_DATE_TIME_FIELD);
                    put("ArchivalReason", ARCHIVAL_REASON_FIELD);
                    put("ArchivalBackupArn", ARCHIVAL_BACKUP_ARN_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Instant archivalDateTime;

    private final String archivalReason;

    private final String archivalBackupArn;

    private ArchivalSummary(BuilderImpl builder) {
        this.archivalDateTime = builder.archivalDateTime;
        this.archivalReason = builder.archivalReason;
        this.archivalBackupArn = builder.archivalBackupArn;
    }

    /**
     * <p>
     * The date and time when table archival was initiated by DynamoDB, in UNIX epoch time format.
     * </p>
     * 
     * @return The date and time when table archival was initiated by DynamoDB, in UNIX epoch time format.
     */
    public final Instant archivalDateTime() {
        return archivalDateTime;
    }

    /**
     * <p>
     * The reason DynamoDB archived the table. Currently, the only possible value is:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The table was archived due to the table's KMS key being
     * inaccessible for more than seven days. An On-Demand backup was created at the archival time.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The reason DynamoDB archived the table. Currently, the only possible value is:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The table was archived due to the table's KMS key
     *         being inaccessible for more than seven days. An On-Demand backup was created at the archival time.
     *         </p>
     *         </li>
     */
    public final String archivalReason() {
        return archivalReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the backup the table was archived to, when applicable in the archival reason.
     * If you wish to restore this backup to the same table name, you will need to delete the original table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the backup the table was archived to, when applicable in the archival
     *         reason. If you wish to restore this backup to the same table name, you will need to delete the original
     *         table.
     */
    public final String archivalBackupArn() {
        return archivalBackupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(archivalDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(archivalReason());
        hashCode = 31 * hashCode + Objects.hashCode(archivalBackupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchivalSummary)) {
            return false;
        }
        ArchivalSummary other = (ArchivalSummary) obj;
        return Objects.equals(archivalDateTime(), other.archivalDateTime())
                && Objects.equals(archivalReason(), other.archivalReason())
                && Objects.equals(archivalBackupArn(), other.archivalBackupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchivalSummary").add("ArchivalDateTime", archivalDateTime())
                .add("ArchivalReason", archivalReason()).add("ArchivalBackupArn", archivalBackupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchivalDateTime":
            return Optional.ofNullable(clazz.cast(archivalDateTime()));
        case "ArchivalReason":
            return Optional.ofNullable(clazz.cast(archivalReason()));
        case "ArchivalBackupArn":
            return Optional.ofNullable(clazz.cast(archivalBackupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ArchivalSummary, T> g) {
        return obj -> g.apply((ArchivalSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchivalSummary> {
        /**
         * <p>
         * The date and time when table archival was initiated by DynamoDB, in UNIX epoch time format.
         * </p>
         * 
         * @param archivalDateTime
         *        The date and time when table archival was initiated by DynamoDB, in UNIX epoch time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archivalDateTime(Instant archivalDateTime);

        /**
         * <p>
         * The reason DynamoDB archived the table. Currently, the only possible value is:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The table was archived due to the table's KMS key being
         * inaccessible for more than seven days. An On-Demand backup was created at the archival time.
         * </p>
         * </li>
         * </ul>
         * 
         * @param archivalReason
         *        The reason DynamoDB archived the table. Currently, the only possible value is:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INACCESSIBLE_ENCRYPTION_CREDENTIALS</code> - The table was archived due to the table's KMS key
         *        being inaccessible for more than seven days. An On-Demand backup was created at the archival time.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archivalReason(String archivalReason);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the backup the table was archived to, when applicable in the archival
         * reason. If you wish to restore this backup to the same table name, you will need to delete the original
         * table.
         * </p>
         * 
         * @param archivalBackupArn
         *        The Amazon Resource Name (ARN) of the backup the table was archived to, when applicable in the
         *        archival reason. If you wish to restore this backup to the same table name, you will need to delete
         *        the original table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archivalBackupArn(String archivalBackupArn);
    }

    static final class BuilderImpl implements Builder {
        private Instant archivalDateTime;

        private String archivalReason;

        private String archivalBackupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchivalSummary model) {
            archivalDateTime(model.archivalDateTime);
            archivalReason(model.archivalReason);
            archivalBackupArn(model.archivalBackupArn);
        }

        public final Instant getArchivalDateTime() {
            return archivalDateTime;
        }

        public final void setArchivalDateTime(Instant archivalDateTime) {
            this.archivalDateTime = archivalDateTime;
        }

        @Override
        public final Builder archivalDateTime(Instant archivalDateTime) {
            this.archivalDateTime = archivalDateTime;
            return this;
        }

        public final String getArchivalReason() {
            return archivalReason;
        }

        public final void setArchivalReason(String archivalReason) {
            this.archivalReason = archivalReason;
        }

        @Override
        public final Builder archivalReason(String archivalReason) {
            this.archivalReason = archivalReason;
            return this;
        }

        public final String getArchivalBackupArn() {
            return archivalBackupArn;
        }

        public final void setArchivalBackupArn(String archivalBackupArn) {
            this.archivalBackupArn = archivalBackupArn;
        }

        @Override
        public final Builder archivalBackupArn(String archivalBackupArn) {
            this.archivalBackupArn = archivalBackupArn;
            return this;
        }

        @Override
        public ArchivalSummary build() {
            return new ArchivalSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
