/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryCacheLoader;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRefreshCache;
import software.amazon.awssdk.core.endpointdiscovery.EndpointDiscoveryRequest;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncEndpointDiscoveryCacheLoader;
import software.amazon.awssdk.services.dynamodb.DynamoDbServiceClientConfiguration;
import software.amazon.awssdk.services.dynamodb.model.BackupInUseException;
import software.amazon.awssdk.services.dynamodb.model.BackupNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchGetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.ContinuousBackupsUnavailableException;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.CreateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteItemResponse;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeExportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeImportResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeLimitsResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableResponse;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.DisableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.DuplicateItemException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationRequest;
import software.amazon.awssdk.services.dynamodb.model.EnableKinesisStreamingDestinationResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteTransactionResponse;
import software.amazon.awssdk.services.dynamodb.model.ExportConflictException;
import software.amazon.awssdk.services.dynamodb.model.ExportNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.ExportTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.GlobalTableNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.dynamodb.model.ImportConflictException;
import software.amazon.awssdk.services.dynamodb.model.ImportNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.ImportTableRequest;
import software.amazon.awssdk.services.dynamodb.model.ImportTableResponse;
import software.amazon.awssdk.services.dynamodb.model.IndexNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.InvalidExportTimeException;
import software.amazon.awssdk.services.dynamodb.model.InvalidRestoreTimeException;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListExportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListExportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListGlobalTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListImportsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListImportsResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTablesRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTablesResponse;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.ListTagsOfResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.PointInTimeRecoveryUnavailableException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.ReplicaAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.ReplicaNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.RequestLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableFromBackupResponse;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeRequest;
import software.amazon.awssdk.services.dynamodb.model.RestoreTableToPointInTimeResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.awssdk.services.dynamodb.model.TableAlreadyExistsException;
import software.amazon.awssdk.services.dynamodb.model.TableInUseException;
import software.amazon.awssdk.services.dynamodb.model.TableNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.TagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactWriteItemsResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;
import software.amazon.awssdk.services.dynamodb.model.TransactionInProgressException;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceRequest;
import software.amazon.awssdk.services.dynamodb.model.UntagResourceResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContinuousBackupsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateContributorInsightsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateGlobalTableSettingsResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableReplicaAutoScalingResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTableResponse;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveRequest;
import software.amazon.awssdk.services.dynamodb.model.UpdateTimeToLiveResponse;
import software.amazon.awssdk.services.dynamodb.paginators.BatchGetItemPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ListContributorInsightsPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ListExportsPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ListImportsPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ListTablesPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.QueryPublisher;
import software.amazon.awssdk.services.dynamodb.paginators.ScanPublisher;
import software.amazon.awssdk.services.dynamodb.transform.BatchExecuteStatementRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchGetItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.BatchWriteItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.CreateTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DeleteTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeContinuousBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeEndpointsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeExportRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeGlobalTableSettingsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeImportRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeLimitsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTableReplicaAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DescribeTimeToLiveRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.DisableKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.EnableKinesisStreamingDestinationRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExecuteStatementRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExecuteTransactionRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ExportTableToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.GetItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ImportTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListExportsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListGlobalTablesRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ListTagsOfResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.PutItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.QueryRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.RestoreTableFromBackupRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.RestoreTableToPointInTimeRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.ScanRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TransactGetItemsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.TransactWriteItemsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateContinuousBackupsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateContributorInsightsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateGlobalTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateGlobalTableSettingsRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateItemRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTableReplicaAutoScalingRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTableRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.transform.UpdateTimeToLiveRequestMarshaller;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultDynamoDbAsyncClient
implements DynamoDbAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultDynamoDbAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final DynamoDbServiceClientConfiguration serviceClientConfiguration;
    private EndpointDiscoveryRefreshCache endpointDiscoveryCache;
    private final ScheduledExecutorService executorService;

    protected DefaultDynamoDbAsyncClient(DynamoDbServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
        if (((Boolean)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED)).booleanValue()) {
            this.endpointDiscoveryCache = EndpointDiscoveryRefreshCache.create((EndpointDiscoveryCacheLoader)DynamoDbAsyncEndpointDiscoveryCacheLoader.create(this));
        }
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public CompletableFuture<BatchExecuteStatementResponse> batchExecuteStatement(BatchExecuteStatementRequest batchExecuteStatementRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchExecuteStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchExecuteStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchExecuteStatementResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchExecuteStatement").withMarshaller((Marshaller)new BatchExecuteStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)batchExecuteStatementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$batchExecuteStatement$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$batchExecuteStatement$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<BatchGetItemResponse> batchGetItem(BatchGetItemRequest batchGetItemRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchGetItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchGetItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchGetItemResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = batchGetItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)batchGetItemRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchGetItem").withMarshaller((Marshaller)new BatchGetItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)batchGetItemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$batchGetItem$5(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$batchGetItem$6((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public BatchGetItemPublisher batchGetItemPaginator(BatchGetItemRequest batchGetItemRequest) {
        return new BatchGetItemPublisher(this, this.applyPaginatorUserAgent(batchGetItemRequest));
    }

    @Override
    public CompletableFuture<BatchWriteItemResponse> batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, batchWriteItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchWriteItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchWriteItemResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = batchWriteItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)batchWriteItemRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchWriteItem").withMarshaller((Marshaller)new BatchWriteItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)batchWriteItemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$batchWriteItem$9(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$batchWriteItem$10((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateBackupResponse> createBackup(CreateBackupRequest createBackupRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, createBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateBackupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = createBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createBackupRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateBackup").withMarshaller((Marshaller)new CreateBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$createBackup$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$createBackup$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateGlobalTableResponse> createGlobalTable(CreateGlobalTableRequest createGlobalTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, createGlobalTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGlobalTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGlobalTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = createGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createGlobalTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGlobalTable").withMarshaller((Marshaller)new CreateGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createGlobalTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$createGlobalTable$17(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$createGlobalTable$18((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateTableResponse> createTable(CreateTableRequest createTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, createTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = createTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)createTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTable").withMarshaller((Marshaller)new CreateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)createTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$createTable$21(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$createTable$22((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteBackupResponse> deleteBackup(DeleteBackupRequest deleteBackupRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteBackupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = deleteBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteBackupRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteBackup").withMarshaller((Marshaller)new DeleteBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$deleteBackup$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$deleteBackup$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteItemResponse> deleteItem(DeleteItemRequest deleteItemRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteItemResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = deleteItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteItemRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteItem").withMarshaller((Marshaller)new DeleteItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteItemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$deleteItem$29(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$deleteItem$30((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteTableResponse> deleteTable(DeleteTableRequest deleteTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = deleteTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)deleteTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTable").withMarshaller((Marshaller)new DeleteTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)deleteTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$deleteTable$33(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$deleteTable$34((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeBackupResponse> describeBackup(DescribeBackupRequest describeBackupRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeBackupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = describeBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeBackupRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeBackup").withMarshaller((Marshaller)new DescribeBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeBackup$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeBackup$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeContinuousBackupsResponse> describeContinuousBackups(DescribeContinuousBackupsRequest describeContinuousBackupsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeContinuousBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContinuousBackups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContinuousBackupsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = describeContinuousBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeContinuousBackupsRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContinuousBackups").withMarshaller((Marshaller)new DescribeContinuousBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeContinuousBackupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeContinuousBackups$41(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeContinuousBackups$42((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeContributorInsightsResponse> describeContributorInsights(DescribeContributorInsightsRequest describeContributorInsightsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeContributorInsights");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeContributorInsightsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeContributorInsights").withMarshaller((Marshaller)new DescribeContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeContributorInsightsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeContributorInsights$44(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeContributorInsights$45((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEndpointsResponse> describeEndpoints(DescribeEndpointsRequest describeEndpointsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeEndpointsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEndpoints");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEndpointsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEndpoints").withMarshaller((Marshaller)new DescribeEndpointsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEndpointsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeEndpoints$47(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeEndpoints$48((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeExportResponse> describeExport(DescribeExportRequest describeExportRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeExportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeExportResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExport").withMarshaller((Marshaller)new DescribeExportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeExportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeExport$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeExport$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeGlobalTableResponse> describeGlobalTable(DescribeGlobalTableRequest describeGlobalTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeGlobalTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGlobalTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGlobalTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = describeGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeGlobalTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGlobalTable").withMarshaller((Marshaller)new DescribeGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeGlobalTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeGlobalTable$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeGlobalTable$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeGlobalTableSettingsResponse> describeGlobalTableSettings(DescribeGlobalTableSettingsRequest describeGlobalTableSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeGlobalTableSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeGlobalTableSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeGlobalTableSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = describeGlobalTableSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeGlobalTableSettingsRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeGlobalTableSettings").withMarshaller((Marshaller)new DescribeGlobalTableSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeGlobalTableSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeGlobalTableSettings$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeGlobalTableSettings$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeImportResponse> describeImport(DescribeImportRequest describeImportRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImport");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImportResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImport").withMarshaller((Marshaller)new DescribeImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeImportRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeImport$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeImport$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeKinesisStreamingDestinationResponse> describeKinesisStreamingDestination(DescribeKinesisStreamingDestinationRequest describeKinesisStreamingDestinationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeKinesisStreamingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeKinesisStreamingDestinationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = describeKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeKinesisStreamingDestination").withMarshaller((Marshaller)new DescribeKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeKinesisStreamingDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeKinesisStreamingDestination$65(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeKinesisStreamingDestination$66((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLimitsResponse> describeLimits(DescribeLimitsRequest describeLimitsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLimits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLimitsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = describeLimitsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeLimitsRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLimits").withMarshaller((Marshaller)new DescribeLimitsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeLimitsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeLimits$69(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeLimits$70((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTableResponse> describeTable(DescribeTableRequest describeTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = describeTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTable").withMarshaller((Marshaller)new DescribeTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeTable$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeTable$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTableReplicaAutoScalingResponse> describeTableReplicaAutoScaling(DescribeTableReplicaAutoScalingRequest describeTableReplicaAutoScalingRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeTableReplicaAutoScalingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTableReplicaAutoScaling");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableReplicaAutoScalingResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTableReplicaAutoScaling").withMarshaller((Marshaller)new DescribeTableReplicaAutoScalingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeTableReplicaAutoScalingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeTableReplicaAutoScaling$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeTableReplicaAutoScaling$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeTimeToLiveResponse> describeTimeToLive(DescribeTimeToLiveRequest describeTimeToLiveRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeTimeToLiveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTimeToLive");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTimeToLiveResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = describeTimeToLiveRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)describeTimeToLiveRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTimeToLive").withMarshaller((Marshaller)new DescribeTimeToLiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)describeTimeToLiveRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$describeTimeToLive$80(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$describeTimeToLive$81((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableKinesisStreamingDestinationResponse> disableKinesisStreamingDestination(DisableKinesisStreamingDestinationRequest disableKinesisStreamingDestinationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableKinesisStreamingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableKinesisStreamingDestinationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = disableKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)disableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableKinesisStreamingDestination").withMarshaller((Marshaller)new DisableKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)disableKinesisStreamingDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$disableKinesisStreamingDestination$84(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$disableKinesisStreamingDestination$85((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableKinesisStreamingDestinationResponse> enableKinesisStreamingDestination(EnableKinesisStreamingDestinationRequest enableKinesisStreamingDestinationRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableKinesisStreamingDestination");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableKinesisStreamingDestinationResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = enableKinesisStreamingDestinationRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)enableKinesisStreamingDestinationRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableKinesisStreamingDestination").withMarshaller((Marshaller)new EnableKinesisStreamingDestinationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)enableKinesisStreamingDestinationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$enableKinesisStreamingDestination$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$enableKinesisStreamingDestination$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExecuteStatementResponse> executeStatement(ExecuteStatementRequest executeStatementRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, executeStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteStatement");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteStatementResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteStatement").withMarshaller((Marshaller)new ExecuteStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)executeStatementRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$executeStatement$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$executeStatement$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExecuteTransactionResponse> executeTransaction(ExecuteTransactionRequest executeTransactionRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, executeTransactionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteTransaction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteTransactionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteTransaction").withMarshaller((Marshaller)new ExecuteTransactionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)executeTransactionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$executeTransaction$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$executeTransaction$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ExportTableToPointInTimeResponse> exportTableToPointInTime(ExportTableToPointInTimeRequest exportTableToPointInTimeRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, exportTableToPointInTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExportTableToPointInTime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExportTableToPointInTimeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExportTableToPointInTime").withMarshaller((Marshaller)new ExportTableToPointInTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)exportTableToPointInTimeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$exportTableToPointInTime$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$exportTableToPointInTime$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetItemResponse> getItem(GetItemRequest getItemRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, getItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetItemResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = getItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)getItemRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetItem").withMarshaller((Marshaller)new GetItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)getItemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$getItem$101(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$getItem$102((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportTableResponse> importTable(ImportTableRequest importTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, importTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportTable").withMarshaller((Marshaller)new ImportTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$importTable$104(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$importTable$105((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListBackupsResponse> listBackups(ListBackupsRequest listBackupsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, listBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListBackups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListBackupsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = listBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listBackupsRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListBackups").withMarshaller((Marshaller)new ListBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listBackupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listBackups$108(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listBackups$109((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListContributorInsightsResponse> listContributorInsights(ListContributorInsightsRequest listContributorInsightsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, listContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListContributorInsights");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListContributorInsightsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListContributorInsights").withMarshaller((Marshaller)new ListContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listContributorInsightsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listContributorInsights$111(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listContributorInsights$112((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListContributorInsightsPublisher listContributorInsightsPaginator(ListContributorInsightsRequest listContributorInsightsRequest) {
        return new ListContributorInsightsPublisher(this, this.applyPaginatorUserAgent(listContributorInsightsRequest));
    }

    @Override
    public CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, listExportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListExports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListExportsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListExports").withMarshaller((Marshaller)new ListExportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listExportsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listExports$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listExports$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListExportsPublisher listExportsPaginator(ListExportsRequest listExportsRequest) {
        return new ListExportsPublisher(this, this.applyPaginatorUserAgent(listExportsRequest));
    }

    @Override
    public CompletableFuture<ListGlobalTablesResponse> listGlobalTables(ListGlobalTablesRequest listGlobalTablesRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, listGlobalTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGlobalTables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGlobalTablesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = listGlobalTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listGlobalTablesRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGlobalTables").withMarshaller((Marshaller)new ListGlobalTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listGlobalTablesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listGlobalTables$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listGlobalTables$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, listImportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImports").withMarshaller((Marshaller)new ListImportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listImportsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listImports$121(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listImports$122((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListImportsPublisher listImportsPaginator(ListImportsRequest listImportsRequest) {
        return new ListImportsPublisher(this, this.applyPaginatorUserAgent(listImportsRequest));
    }

    @Override
    public CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTables");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTablesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = listTablesRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTablesRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTables").withMarshaller((Marshaller)new ListTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTablesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listTables$125(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listTables$126((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListTablesPublisher listTablesPaginator(ListTablesRequest listTablesRequest) {
        return new ListTablesPublisher(this, this.applyPaginatorUserAgent(listTablesRequest));
    }

    @Override
    public CompletableFuture<ListTagsOfResourceResponse> listTagsOfResource(ListTagsOfResourceRequest listTagsOfResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsOfResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsOfResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsOfResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = listTagsOfResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)listTagsOfResourceRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsOfResource").withMarshaller((Marshaller)new ListTagsOfResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)listTagsOfResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$listTagsOfResource$129(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$listTagsOfResource$130((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutItemResponse> putItem(PutItemRequest putItemRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, putItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutItemResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = putItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)putItemRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutItem").withMarshaller((Marshaller)new PutItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)putItemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$putItem$133(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$putItem$134((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<QueryResponse> query(QueryRequest queryRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, queryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Query");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, QueryResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = queryRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)queryRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("Query").withMarshaller((Marshaller)new QueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)queryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$query$137(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$query$138((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public QueryPublisher queryPaginator(QueryRequest queryRequest) {
        return new QueryPublisher(this, this.applyPaginatorUserAgent(queryRequest));
    }

    @Override
    public CompletableFuture<RestoreTableFromBackupResponse> restoreTableFromBackup(RestoreTableFromBackupRequest restoreTableFromBackupRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, restoreTableFromBackupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableFromBackup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreTableFromBackupResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = restoreTableFromBackupRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)restoreTableFromBackupRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableFromBackup").withMarshaller((Marshaller)new RestoreTableFromBackupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)restoreTableFromBackupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$restoreTableFromBackup$141(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$restoreTableFromBackup$142((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<RestoreTableToPointInTimeResponse> restoreTableToPointInTime(RestoreTableToPointInTimeRequest restoreTableToPointInTimeRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, restoreTableToPointInTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreTableToPointInTime");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreTableToPointInTimeResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = restoreTableToPointInTimeRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)restoreTableToPointInTimeRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreTableToPointInTime").withMarshaller((Marshaller)new RestoreTableToPointInTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)restoreTableToPointInTimeRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$restoreTableToPointInTime$145(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$restoreTableToPointInTime$146((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ScanResponse> scan(ScanRequest scanRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, scanRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"Scan");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ScanResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = scanRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)scanRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("Scan").withMarshaller((Marshaller)new ScanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)scanRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$scan$149(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$scan$150((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ScanPublisher scanPaginator(ScanRequest scanRequest) {
        return new ScanPublisher(this, this.applyPaginatorUserAgent(scanRequest));
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = tagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)tagResourceRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$tagResource$153(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$tagResource$154((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TransactGetItemsResponse> transactGetItems(TransactGetItemsRequest transactGetItemsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, transactGetItemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransactGetItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransactGetItemsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = transactGetItemsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)transactGetItemsRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransactGetItems").withMarshaller((Marshaller)new TransactGetItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)transactGetItemsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$transactGetItems$157(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$transactGetItems$158((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TransactWriteItemsResponse> transactWriteItems(TransactWriteItemsRequest transactWriteItemsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, transactWriteItemsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TransactWriteItems");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransactWriteItemsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = transactWriteItemsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)transactWriteItemsRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransactWriteItems").withMarshaller((Marshaller)new TransactWriteItemsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)transactWriteItemsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$transactWriteItems$161(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$transactWriteItems$162((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = untagResourceRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)untagResourceRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$untagResource$165(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$untagResource$166((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateContinuousBackupsResponse> updateContinuousBackups(UpdateContinuousBackupsRequest updateContinuousBackupsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateContinuousBackupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContinuousBackups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContinuousBackupsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = updateContinuousBackupsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateContinuousBackupsRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContinuousBackups").withMarshaller((Marshaller)new UpdateContinuousBackupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateContinuousBackupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateContinuousBackups$169(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateContinuousBackups$170((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateContributorInsightsResponse> updateContributorInsights(UpdateContributorInsightsRequest updateContributorInsightsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateContributorInsightsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateContributorInsights");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateContributorInsightsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateContributorInsights").withMarshaller((Marshaller)new UpdateContributorInsightsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateContributorInsightsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateContributorInsights$172(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateContributorInsights$173((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGlobalTableResponse> updateGlobalTable(UpdateGlobalTableRequest updateGlobalTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateGlobalTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = updateGlobalTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateGlobalTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalTable").withMarshaller((Marshaller)new UpdateGlobalTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateGlobalTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateGlobalTable$176(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateGlobalTable$177((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateGlobalTableSettingsResponse> updateGlobalTableSettings(UpdateGlobalTableSettingsRequest updateGlobalTableSettingsRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateGlobalTableSettingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGlobalTableSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGlobalTableSettingsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = updateGlobalTableSettingsRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateGlobalTableSettingsRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGlobalTableSettings").withMarshaller((Marshaller)new UpdateGlobalTableSettingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateGlobalTableSettingsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateGlobalTableSettings$180(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateGlobalTableSettings$181((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateItemResponse> updateItem(UpdateItemRequest updateItemRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateItemRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateItem");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateItemResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = updateItemRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateItemRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateItem").withMarshaller((Marshaller)new UpdateItemRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateItemRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateItem$184(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateItem$185((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableResponse> updateTable(UpdateTableRequest updateTableRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTable");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = updateTableRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateTableRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTable").withMarshaller((Marshaller)new UpdateTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateTableRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateTable$188(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateTable$189((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTableReplicaAutoScalingResponse> updateTableReplicaAutoScaling(UpdateTableReplicaAutoScalingRequest updateTableReplicaAutoScalingRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateTableReplicaAutoScalingRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTableReplicaAutoScaling");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTableReplicaAutoScalingResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTableReplicaAutoScaling").withMarshaller((Marshaller)new UpdateTableReplicaAutoScalingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateTableReplicaAutoScalingRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateTableReplicaAutoScaling$191(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateTableReplicaAutoScaling$192((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateTimeToLiveResponse> updateTimeToLive(UpdateTimeToLiveRequest updateTimeToLiveRequest) {
        List<MetricPublisher> metricPublishers = DefaultDynamoDbAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateTimeToLiveRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DynamoDB");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTimeToLive");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTimeToLiveResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            boolean endpointDiscoveryEnabled = (Boolean)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_DISCOVERY_ENABLED);
            boolean endpointOverridden = this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) == Boolean.TRUE;
            URI cachedEndpoint = null;
            if (endpointDiscoveryEnabled) {
                String key = updateTimeToLiveRequest.overrideConfiguration().flatMap(AwsRequestOverrideConfiguration::credentialsProvider).orElseGet(() -> (AwsCredentialsProvider)this.clientConfiguration.option((ClientOption)AwsClientOption.CREDENTIALS_PROVIDER)).resolveCredentials().accessKeyId();
                EndpointDiscoveryRequest endpointDiscoveryRequest = (EndpointDiscoveryRequest)EndpointDiscoveryRequest.builder().required(false).defaultEndpoint((URI)this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT)).overrideConfiguration((RequestOverrideConfiguration)updateTimeToLiveRequest.overrideConfiguration().orElse(null)).build();
                cachedEndpoint = this.endpointDiscoveryCache.get(key, endpointDiscoveryRequest);
            }
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTimeToLive").withMarshaller((Marshaller)new UpdateTimeToLiveRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).discoveredEndpoint(cachedEndpoint).withInput((SdkRequest)updateTimeToLiveRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultDynamoDbAsyncClient.lambda$updateTimeToLive$195(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultDynamoDbAsyncClient.lambda$updateTimeToLive$196((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DynamoDbAsyncWaiter waiter() {
        return DynamoDbAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    @Override
    public final DynamoDbServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public final String serviceName() {
        return "dynamodb";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DynamoDbException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("RequestLimitExceeded").exceptionBuilderSupplier(RequestLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GlobalTableAlreadyExistsException").exceptionBuilderSupplier(GlobalTableAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ImportConflictException").exceptionBuilderSupplier(ImportConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConditionalCheckFailedException").exceptionBuilderSupplier(ConditionalCheckFailedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("GlobalTableNotFoundException").exceptionBuilderSupplier(GlobalTableNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ItemCollectionSizeLimitExceededException").exceptionBuilderSupplier(ItemCollectionSizeLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicaNotFoundException").exceptionBuilderSupplier(ReplicaNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BackupInUseException").exceptionBuilderSupplier(BackupInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ContinuousBackupsUnavailableException").exceptionBuilderSupplier(ContinuousBackupsUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IdempotentParameterMismatchException").exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExportNotFoundException").exceptionBuilderSupplier(ExportNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TransactionInProgressException").exceptionBuilderSupplier(TransactionInProgressException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableInUseException").exceptionBuilderSupplier(TableInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ProvisionedThroughputExceededException").exceptionBuilderSupplier(ProvisionedThroughputExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PointInTimeRecoveryUnavailableException").exceptionBuilderSupplier(PointInTimeRecoveryUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUseException").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableAlreadyExistsException").exceptionBuilderSupplier(TableAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ExportConflictException").exceptionBuilderSupplier(ExportConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TransactionConflictException").exceptionBuilderSupplier(TransactionConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidRestoreTimeException").exceptionBuilderSupplier(InvalidRestoreTimeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ReplicaAlreadyExistsException").exceptionBuilderSupplier(ReplicaAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BackupNotFoundException").exceptionBuilderSupplier(BackupNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IndexNotFoundException").exceptionBuilderSupplier(IndexNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TableNotFoundException").exceptionBuilderSupplier(TableNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateItemException").exceptionBuilderSupplier(DuplicateItemException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ImportNotFoundException").exceptionBuilderSupplier(ImportNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TransactionCanceledException").exceptionBuilderSupplier(TransactionCanceledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidExportTimeException").exceptionBuilderSupplier(InvalidExportTimeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerError").exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends DynamoDbRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.81").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DynamoDbRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateTimeToLive$196(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTimeToLive$195(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTimeToLiveResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTableReplicaAutoScaling$192(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTableReplicaAutoScaling$191(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTableReplicaAutoScalingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateTable$189(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateTable$188(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateItem$185(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateItem$184(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateGlobalTableSettings$181(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalTableSettings$180(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateGlobalTableSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateGlobalTable$177(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGlobalTable$176(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateGlobalTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateContributorInsights$173(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContributorInsights$172(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateContributorInsightsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateContinuousBackups$170(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateContinuousBackups$169(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateContinuousBackupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$166(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$165(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$transactWriteItems$162(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transactWriteItems$161(List metricPublishers, MetricCollector apiCallMetricCollector, TransactWriteItemsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$transactGetItems$158(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$transactGetItems$157(List metricPublishers, MetricCollector apiCallMetricCollector, TransactGetItemsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$154(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$153(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$scan$150(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$scan$149(List metricPublishers, MetricCollector apiCallMetricCollector, ScanResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restoreTableToPointInTime$146(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTableToPointInTime$145(List metricPublishers, MetricCollector apiCallMetricCollector, RestoreTableToPointInTimeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$restoreTableFromBackup$142(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreTableFromBackup$141(List metricPublishers, MetricCollector apiCallMetricCollector, RestoreTableFromBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$query$138(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$query$137(List metricPublishers, MetricCollector apiCallMetricCollector, QueryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putItem$134(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putItem$133(List metricPublishers, MetricCollector apiCallMetricCollector, PutItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsOfResource$130(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsOfResource$129(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsOfResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTables$126(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTables$125(List metricPublishers, MetricCollector apiCallMetricCollector, ListTablesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listImports$122(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImports$121(List metricPublishers, MetricCollector apiCallMetricCollector, ListImportsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listGlobalTables$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGlobalTables$118(List metricPublishers, MetricCollector apiCallMetricCollector, ListGlobalTablesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listExports$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listExports$114(List metricPublishers, MetricCollector apiCallMetricCollector, ListExportsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listContributorInsights$112(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listContributorInsights$111(List metricPublishers, MetricCollector apiCallMetricCollector, ListContributorInsightsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listBackups$109(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listBackups$108(List metricPublishers, MetricCollector apiCallMetricCollector, ListBackupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importTable$105(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importTable$104(List metricPublishers, MetricCollector apiCallMetricCollector, ImportTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getItem$102(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getItem$101(List metricPublishers, MetricCollector apiCallMetricCollector, GetItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$exportTableToPointInTime$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$exportTableToPointInTime$97(List metricPublishers, MetricCollector apiCallMetricCollector, ExportTableToPointInTimeResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$executeTransaction$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeTransaction$94(List metricPublishers, MetricCollector apiCallMetricCollector, ExecuteTransactionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$executeStatement$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeStatement$91(List metricPublishers, MetricCollector apiCallMetricCollector, ExecuteStatementResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableKinesisStreamingDestination$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableKinesisStreamingDestination$88(List metricPublishers, MetricCollector apiCallMetricCollector, EnableKinesisStreamingDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableKinesisStreamingDestination$85(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableKinesisStreamingDestination$84(List metricPublishers, MetricCollector apiCallMetricCollector, DisableKinesisStreamingDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTimeToLive$81(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTimeToLive$80(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTimeToLiveResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTableReplicaAutoScaling$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTableReplicaAutoScaling$76(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTableReplicaAutoScalingResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeTable$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTable$73(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLimits$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLimits$69(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLimitsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeKinesisStreamingDestination$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeKinesisStreamingDestination$65(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeKinesisStreamingDestinationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeImport$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImport$61(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeImportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeGlobalTableSettings$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGlobalTableSettings$58(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeGlobalTableSettingsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeGlobalTable$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeGlobalTable$54(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeGlobalTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeExport$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExport$50(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeExportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEndpoints$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEndpoints$47(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEndpointsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeContributorInsights$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContributorInsights$44(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeContributorInsightsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeContinuousBackups$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeContinuousBackups$41(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeContinuousBackupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeBackup$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeBackup$37(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteTable$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTable$33(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteItem$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteItem$29(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteBackup$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteBackup$25(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createTable$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTable$21(List metricPublishers, MetricCollector apiCallMetricCollector, CreateTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createGlobalTable$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGlobalTable$17(List metricPublishers, MetricCollector apiCallMetricCollector, CreateGlobalTableResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createBackup$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createBackup$13(List metricPublishers, MetricCollector apiCallMetricCollector, CreateBackupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchWriteItem$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchWriteItem$9(List metricPublishers, MetricCollector apiCallMetricCollector, BatchWriteItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchGetItem$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchGetItem$5(List metricPublishers, MetricCollector apiCallMetricCollector, BatchGetItemResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$batchExecuteStatement$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchExecuteStatement$1(List metricPublishers, MetricCollector apiCallMetricCollector, BatchExecuteStatementResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

