/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.streams;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.streams.DefaultDynamoDbStreamsBaseClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.DefaultDynamoDbStreamsClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClientBuilder;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsServiceClientConfiguration;
import software.amazon.awssdk.services.dynamodb.streams.endpoints.DynamoDbStreamsEndpointProvider;

@SdkInternalApi
final class DefaultDynamoDbStreamsClientBuilder
extends DefaultDynamoDbStreamsBaseClientBuilder<DynamoDbStreamsClientBuilder, DynamoDbStreamsClient>
implements DynamoDbStreamsClientBuilder {
    DefaultDynamoDbStreamsClientBuilder() {
    }

    @Override
    public DefaultDynamoDbStreamsClientBuilder endpointProvider(DynamoDbStreamsEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DynamoDbStreamsClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultDynamoDbStreamsClientBuilder.validateClientOptions(clientConfiguration);
        DynamoDbStreamsServiceClientConfiguration serviceClientConfiguration = DynamoDbStreamsServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultDynamoDbStreamsClient(serviceClientConfiguration, clientConfiguration);
    }
}

