/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.SSEType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SSESpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SSESpecification> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(SSESpecification.getter(SSESpecification::enabled)).setter(SSESpecification.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<String> SSE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SSEType").getter(SSESpecification.getter(SSESpecification::sseTypeAsString)).setter(SSESpecification.setter(Builder::sseType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEType").build()}).build();
    private static final SdkField<String> KMS_MASTER_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSMasterKeyId").getter(SSESpecification.getter(SSESpecification::kmsMasterKeyId)).setter(SSESpecification.setter(Builder::kmsMasterKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSMasterKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, SSE_TYPE_FIELD, KMS_MASTER_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final String sseType;
    private final String kmsMasterKeyId;

    private SSESpecification(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.sseType = builder.sseType;
        this.kmsMasterKeyId = builder.kmsMasterKeyId;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final SSEType sseType() {
        return SSEType.fromValue(this.sseType);
    }

    public final String sseTypeAsString() {
        return this.sseType;
    }

    public final String kmsMasterKeyId() {
        return this.kmsMasterKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsMasterKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SSESpecification)) {
            return false;
        }
        SSESpecification other = (SSESpecification)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.sseTypeAsString(), other.sseTypeAsString()) && Objects.equals(this.kmsMasterKeyId(), other.kmsMasterKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"SSESpecification").add("Enabled", (Object)this.enabled()).add("SSEType", (Object)this.sseTypeAsString()).add("KMSMasterKeyId", (Object)this.kmsMasterKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "SSEType": {
                return Optional.ofNullable(clazz.cast(this.sseTypeAsString()));
            }
            case "KMSMasterKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsMasterKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SSESpecification, T> g) {
        return obj -> g.apply((SSESpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String sseType;
        private String kmsMasterKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(SSESpecification model) {
            this.enabled(model.enabled);
            this.sseType(model.sseType);
            this.kmsMasterKeyId(model.kmsMasterKeyId);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getSseType() {
            return this.sseType;
        }

        public final void setSseType(String sseType) {
            this.sseType = sseType;
        }

        @Override
        @Transient
        public final Builder sseType(String sseType) {
            this.sseType = sseType;
            return this;
        }

        @Override
        @Transient
        public final Builder sseType(SSEType sseType) {
            this.sseType(sseType == null ? null : sseType.toString());
            return this;
        }

        public final String getKmsMasterKeyId() {
            return this.kmsMasterKeyId;
        }

        public final void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        @Override
        @Transient
        public final Builder kmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
            return this;
        }

        public SSESpecification build() {
            return new SSESpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SSESpecification> {
        public Builder enabled(Boolean var1);

        public Builder sseType(String var1);

        public Builder sseType(SSEType var1);

        public Builder kmsMasterKeyId(String var1);
    }
}

