/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.DestinationStatus;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableKinesisStreamingDestinationResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, DisableKinesisStreamingDestinationResponse> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(DisableKinesisStreamingDestinationResponse.getter(DisableKinesisStreamingDestinationResponse::tableName)).setter(DisableKinesisStreamingDestinationResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamArn").getter(DisableKinesisStreamingDestinationResponse.getter(DisableKinesisStreamingDestinationResponse::streamArn)).setter(DisableKinesisStreamingDestinationResponse.setter(Builder::streamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamArn").build()}).build();
    private static final SdkField<String> DESTINATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationStatus").getter(DisableKinesisStreamingDestinationResponse.getter(DisableKinesisStreamingDestinationResponse::destinationStatusAsString)).setter(DisableKinesisStreamingDestinationResponse.setter(Builder::destinationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, STREAM_ARN_FIELD, DESTINATION_STATUS_FIELD));
    private final String tableName;
    private final String streamArn;
    private final String destinationStatus;

    private DisableKinesisStreamingDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.streamArn = builder.streamArn;
        this.destinationStatus = builder.destinationStatus;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String streamArn() {
        return this.streamArn;
    }

    public final DestinationStatus destinationStatus() {
        return DestinationStatus.fromValue(this.destinationStatus);
    }

    public final String destinationStatusAsString() {
        return this.destinationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableKinesisStreamingDestinationResponse)) {
            return false;
        }
        DisableKinesisStreamingDestinationResponse other = (DisableKinesisStreamingDestinationResponse)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.streamArn(), other.streamArn()) && Objects.equals(this.destinationStatusAsString(), other.destinationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DisableKinesisStreamingDestinationResponse").add("TableName", (Object)this.tableName()).add("StreamArn", (Object)this.streamArn()).add("DestinationStatus", (Object)this.destinationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "StreamArn": {
                return Optional.ofNullable(clazz.cast(this.streamArn()));
            }
            case "DestinationStatus": {
                return Optional.ofNullable(clazz.cast(this.destinationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableKinesisStreamingDestinationResponse, T> g) {
        return obj -> g.apply((DisableKinesisStreamingDestinationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private String tableName;
        private String streamArn;
        private String destinationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableKinesisStreamingDestinationResponse model) {
            super(model);
            this.tableName(model.tableName);
            this.streamArn(model.streamArn);
            this.destinationStatus(model.destinationStatus);
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getStreamArn() {
            return this.streamArn;
        }

        public final void setStreamArn(String streamArn) {
            this.streamArn = streamArn;
        }

        @Override
        @Transient
        public final Builder streamArn(String streamArn) {
            this.streamArn = streamArn;
            return this;
        }

        public final String getDestinationStatus() {
            return this.destinationStatus;
        }

        public final void setDestinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
        }

        @Override
        @Transient
        public final Builder destinationStatus(String destinationStatus) {
            this.destinationStatus = destinationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder destinationStatus(DestinationStatus destinationStatus) {
            this.destinationStatus(destinationStatus == null ? null : destinationStatus.toString());
            return this;
        }

        @Override
        public DisableKinesisStreamingDestinationResponse build() {
            return new DisableKinesisStreamingDestinationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableKinesisStreamingDestinationResponse> {
        public Builder tableName(String var1);

        public Builder streamArn(String var1);

        public Builder destinationStatus(String var1);

        public Builder destinationStatus(DestinationStatus var1);
    }
}

