/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dynamodb.model.ConditionCheck;
import software.amazon.awssdk.services.dynamodb.model.Delete;
import software.amazon.awssdk.services.dynamodb.model.Put;
import software.amazon.awssdk.services.dynamodb.model.Update;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransactWriteItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransactWriteItem> {
    private static final SdkField<ConditionCheck> CONDITION_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConditionCheck").getter(TransactWriteItem.getter(TransactWriteItem::conditionCheck)).setter(TransactWriteItem.setter(Builder::conditionCheck)).constructor(ConditionCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionCheck").build()}).build();
    private static final SdkField<Put> PUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Put").getter(TransactWriteItem.getter(TransactWriteItem::put)).setter(TransactWriteItem.setter(Builder::put)).constructor(Put::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Put").build()}).build();
    private static final SdkField<Delete> DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Delete").getter(TransactWriteItem.getter(TransactWriteItem::delete)).setter(TransactWriteItem.setter(Builder::delete)).constructor(Delete::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delete").build()}).build();
    private static final SdkField<Update> UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Update").getter(TransactWriteItem.getter(TransactWriteItem::update)).setter(TransactWriteItem.setter(Builder::update)).constructor(Update::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Update").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_CHECK_FIELD, PUT_FIELD, DELETE_FIELD, UPDATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final ConditionCheck conditionCheck;
    private final Put put;
    private final Delete delete;
    private final Update update;

    private TransactWriteItem(BuilderImpl builder) {
        this.conditionCheck = builder.conditionCheck;
        this.put = builder.put;
        this.delete = builder.delete;
        this.update = builder.update;
    }

    public final ConditionCheck conditionCheck() {
        return this.conditionCheck;
    }

    public final Put put() {
        return this.put;
    }

    public final Delete delete() {
        return this.delete;
    }

    public final Update update() {
        return this.update;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.put());
        hashCode = 31 * hashCode + Objects.hashCode(this.delete());
        hashCode = 31 * hashCode + Objects.hashCode(this.update());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactWriteItem)) {
            return false;
        }
        TransactWriteItem other = (TransactWriteItem)obj;
        return Objects.equals(this.conditionCheck(), other.conditionCheck()) && Objects.equals(this.put(), other.put()) && Objects.equals(this.delete(), other.delete()) && Objects.equals(this.update(), other.update());
    }

    public final String toString() {
        return ToString.builder((String)"TransactWriteItem").add("ConditionCheck", (Object)this.conditionCheck()).add("Put", (Object)this.put()).add("Delete", (Object)this.delete()).add("Update", (Object)this.update()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConditionCheck": {
                return Optional.ofNullable(clazz.cast(this.conditionCheck()));
            }
            case "Put": {
                return Optional.ofNullable(clazz.cast(this.put()));
            }
            case "Delete": {
                return Optional.ofNullable(clazz.cast(this.delete()));
            }
            case "Update": {
                return Optional.ofNullable(clazz.cast(this.update()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactWriteItem, T> g) {
        return obj -> g.apply((TransactWriteItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ConditionCheck conditionCheck;
        private Put put;
        private Delete delete;
        private Update update;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactWriteItem model) {
            this.conditionCheck(model.conditionCheck);
            this.put(model.put);
            this.delete(model.delete);
            this.update(model.update);
        }

        public final ConditionCheck.Builder getConditionCheck() {
            return this.conditionCheck != null ? this.conditionCheck.toBuilder() : null;
        }

        @Override
        public final Builder conditionCheck(ConditionCheck conditionCheck) {
            this.conditionCheck = conditionCheck;
            return this;
        }

        public final void setConditionCheck(ConditionCheck.BuilderImpl conditionCheck) {
            this.conditionCheck = conditionCheck != null ? conditionCheck.build() : null;
        }

        public final Put.Builder getPut() {
            return this.put != null ? this.put.toBuilder() : null;
        }

        @Override
        public final Builder put(Put put) {
            this.put = put;
            return this;
        }

        public final void setPut(Put.BuilderImpl put) {
            this.put = put != null ? put.build() : null;
        }

        public final Delete.Builder getDelete() {
            return this.delete != null ? this.delete.toBuilder() : null;
        }

        @Override
        public final Builder delete(Delete delete) {
            this.delete = delete;
            return this;
        }

        public final void setDelete(Delete.BuilderImpl delete) {
            this.delete = delete != null ? delete.build() : null;
        }

        public final Update.Builder getUpdate() {
            return this.update != null ? this.update.toBuilder() : null;
        }

        @Override
        public final Builder update(Update update) {
            this.update = update;
            return this;
        }

        public final void setUpdate(Update.BuilderImpl update) {
            this.update = update != null ? update.build() : null;
        }

        public TransactWriteItem build() {
            return new TransactWriteItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransactWriteItem> {
        public Builder conditionCheck(ConditionCheck var1);

        default public Builder conditionCheck(Consumer<ConditionCheck.Builder> conditionCheck) {
            return this.conditionCheck((ConditionCheck)((ConditionCheck.Builder)ConditionCheck.builder().applyMutation(conditionCheck)).build());
        }

        public Builder put(Put var1);

        default public Builder put(Consumer<Put.Builder> put) {
            return this.put((Put)((Put.Builder)Put.builder().applyMutation(put)).build());
        }

        public Builder delete(Delete var1);

        default public Builder delete(Consumer<Delete.Builder> delete) {
            return this.delete((Delete)((Delete.Builder)Delete.builder().applyMutation(delete)).build());
        }

        public Builder update(Update var1);

        default public Builder update(Consumer<Update.Builder> update) {
            return this.update((Update)((Update.Builder)Update.builder().applyMutation(update)).build());
        }
    }
}

