/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacityMultipleCopier;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbResponse;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetricsPerTableCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransactWriteItemsResponse
extends DynamoDbResponse
implements ToCopyableBuilder<Builder, TransactWriteItemsResponse> {
    private static final SdkField<List<ConsumedCapacity>> CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumedCapacity").getter(TransactWriteItemsResponse.getter(TransactWriteItemsResponse::consumedCapacity)).setter(TransactWriteItemsResponse.setter(Builder::consumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedCapacity").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConsumedCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<ItemCollectionMetrics>>> ITEM_COLLECTION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ItemCollectionMetrics").getter(TransactWriteItemsResponse.getter(TransactWriteItemsResponse::itemCollectionMetrics)).setter(TransactWriteItemsResponse.setter(Builder::itemCollectionMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCollectionMetrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ItemCollectionMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMED_CAPACITY_FIELD, ITEM_COLLECTION_METRICS_FIELD));
    private final List<ConsumedCapacity> consumedCapacity;
    private final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;

    private TransactWriteItemsResponse(BuilderImpl builder) {
        super(builder);
        this.consumedCapacity = builder.consumedCapacity;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
    }

    public final boolean hasConsumedCapacity() {
        return this.consumedCapacity != null && !(this.consumedCapacity instanceof SdkAutoConstructList);
    }

    public final List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public final boolean hasItemCollectionMetrics() {
        return this.itemCollectionMetrics != null && !(this.itemCollectionMetrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumedCapacity() ? this.consumedCapacity() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemCollectionMetrics() ? this.itemCollectionMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactWriteItemsResponse)) {
            return false;
        }
        TransactWriteItemsResponse other = (TransactWriteItemsResponse)((Object)obj);
        return this.hasConsumedCapacity() == other.hasConsumedCapacity() && Objects.equals(this.consumedCapacity(), other.consumedCapacity()) && this.hasItemCollectionMetrics() == other.hasItemCollectionMetrics() && Objects.equals(this.itemCollectionMetrics(), other.itemCollectionMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"TransactWriteItemsResponse").add("ConsumedCapacity", this.hasConsumedCapacity() ? this.consumedCapacity() : null).add("ItemCollectionMetrics", this.hasItemCollectionMetrics() ? this.itemCollectionMetrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.consumedCapacity()));
            }
            case "ItemCollectionMetrics": {
                return Optional.ofNullable(clazz.cast(this.itemCollectionMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactWriteItemsResponse, T> g) {
        return obj -> g.apply((TransactWriteItemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbResponse.BuilderImpl
    implements Builder {
        private List<ConsumedCapacity> consumedCapacity = DefaultSdkAutoConstructList.getInstance();
        private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransactWriteItemsResponse model) {
            super(model);
            this.consumedCapacity(model.consumedCapacity);
            this.itemCollectionMetrics(model.itemCollectionMetrics);
        }

        public final Collection<ConsumedCapacity.Builder> getConsumedCapacity() {
            if (this.consumedCapacity instanceof SdkAutoConstructList) {
                return null;
            }
            return this.consumedCapacity != null ? (Collection)this.consumedCapacity.stream().map(ConsumedCapacity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity ... consumedCapacity) {
            this.consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... consumedCapacity) {
            this.consumedCapacity(Stream.of(consumedCapacity).map(c -> (ConsumedCapacity)((ConsumedCapacity.Builder)ConsumedCapacity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        public final Map<String, ? extends Collection<ItemCollectionMetrics>> getItemCollectionMetrics() {
            if (this.itemCollectionMetrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.itemCollectionMetrics;
        }

        @Override
        public final Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
            return this;
        }

        public final void setItemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
        }

        @Override
        public TransactWriteItemsResponse build() {
            return new TransactWriteItemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TransactWriteItemsResponse> {
        public Builder consumedCapacity(Collection<ConsumedCapacity> var1);

        public Builder consumedCapacity(ConsumedCapacity ... var1);

        public Builder consumedCapacity(Consumer<ConsumedCapacity.Builder> ... var1);

        public Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> var1);
    }
}

