/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.ReplicaUpdate;
import software.amazon.awssdk.services.dynamodb.model.ReplicaUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGlobalTableRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, UpdateGlobalTableRequest> {
    private static final SdkField<String> GLOBAL_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalTableName").getter(UpdateGlobalTableRequest.getter(UpdateGlobalTableRequest::globalTableName)).setter(UpdateGlobalTableRequest.setter(Builder::globalTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalTableName").build()}).build();
    private static final SdkField<List<ReplicaUpdate>> REPLICA_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReplicaUpdates").getter(UpdateGlobalTableRequest.getter(UpdateGlobalTableRequest::replicaUpdates)).setter(UpdateGlobalTableRequest.setter(Builder::replicaUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReplicaUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_TABLE_NAME_FIELD, REPLICA_UPDATES_FIELD));
    private final String globalTableName;
    private final List<ReplicaUpdate> replicaUpdates;

    private UpdateGlobalTableRequest(BuilderImpl builder) {
        super(builder);
        this.globalTableName = builder.globalTableName;
        this.replicaUpdates = builder.replicaUpdates;
    }

    public String globalTableName() {
        return this.globalTableName;
    }

    public boolean hasReplicaUpdates() {
        return this.replicaUpdates != null && !(this.replicaUpdates instanceof SdkAutoConstructList);
    }

    public List<ReplicaUpdate> replicaUpdates() {
        return this.replicaUpdates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.globalTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaUpdates());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalTableRequest)) {
            return false;
        }
        UpdateGlobalTableRequest other = (UpdateGlobalTableRequest)((Object)obj);
        return Objects.equals(this.globalTableName(), other.globalTableName()) && Objects.equals(this.replicaUpdates(), other.replicaUpdates());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGlobalTableRequest").add("GlobalTableName", (Object)this.globalTableName()).add("ReplicaUpdates", this.replicaUpdates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalTableName": {
                return Optional.ofNullable(clazz.cast(this.globalTableName()));
            }
            case "ReplicaUpdates": {
                return Optional.ofNullable(clazz.cast(this.replicaUpdates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGlobalTableRequest, T> g) {
        return obj -> g.apply((UpdateGlobalTableRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String globalTableName;
        private List<ReplicaUpdate> replicaUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalTableRequest model) {
            super(model);
            this.globalTableName(model.globalTableName);
            this.replicaUpdates(model.replicaUpdates);
        }

        public final String getGlobalTableName() {
            return this.globalTableName;
        }

        @Override
        public final Builder globalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
            return this;
        }

        public final void setGlobalTableName(String globalTableName) {
            this.globalTableName = globalTableName;
        }

        public final Collection<ReplicaUpdate.Builder> getReplicaUpdates() {
            return this.replicaUpdates != null ? (Collection)this.replicaUpdates.stream().map(ReplicaUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicaUpdates(Collection<ReplicaUpdate> replicaUpdates) {
            this.replicaUpdates = ReplicaUpdateListCopier.copy(replicaUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(ReplicaUpdate ... replicaUpdates) {
            this.replicaUpdates(Arrays.asList(replicaUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicaUpdates(Consumer<ReplicaUpdate.Builder> ... replicaUpdates) {
            this.replicaUpdates(Stream.of(replicaUpdates).map(c -> (ReplicaUpdate)((ReplicaUpdate.Builder)ReplicaUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicaUpdates(Collection<ReplicaUpdate.BuilderImpl> replicaUpdates) {
            this.replicaUpdates = ReplicaUpdateListCopier.copyFromBuilder(replicaUpdates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGlobalTableRequest build() {
            return new UpdateGlobalTableRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGlobalTableRequest> {
        public Builder globalTableName(String var1);

        public Builder replicaUpdates(Collection<ReplicaUpdate> var1);

        public Builder replicaUpdates(ReplicaUpdate ... var1);

        public Builder replicaUpdates(Consumer<ReplicaUpdate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

