/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.NonKeyAttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProjectionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Projection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Projection> {
    private static final SdkField<String> PROJECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProjectionType").getter(Projection.getter(Projection::projectionTypeAsString)).setter(Projection.setter(Builder::projectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionType").build()}).build();
    private static final SdkField<List<String>> NON_KEY_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NonKeyAttributes").getter(Projection.getter(Projection::nonKeyAttributes)).setter(Projection.setter(Builder::nonKeyAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NonKeyAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECTION_TYPE_FIELD, NON_KEY_ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String projectionType;
    private final List<String> nonKeyAttributes;

    private Projection(BuilderImpl builder) {
        this.projectionType = builder.projectionType;
        this.nonKeyAttributes = builder.nonKeyAttributes;
    }

    public ProjectionType projectionType() {
        return ProjectionType.fromValue(this.projectionType);
    }

    public String projectionTypeAsString() {
        return this.projectionType;
    }

    public boolean hasNonKeyAttributes() {
        return this.nonKeyAttributes != null && !(this.nonKeyAttributes instanceof SdkAutoConstructList);
    }

    public List<String> nonKeyAttributes() {
        return this.nonKeyAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNonKeyAttributes() ? this.nonKeyAttributes() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Projection)) {
            return false;
        }
        Projection other = (Projection)obj;
        return Objects.equals(this.projectionTypeAsString(), other.projectionTypeAsString()) && this.hasNonKeyAttributes() == other.hasNonKeyAttributes() && Objects.equals(this.nonKeyAttributes(), other.nonKeyAttributes());
    }

    public String toString() {
        return ToString.builder((String)"Projection").add("ProjectionType", (Object)this.projectionTypeAsString()).add("NonKeyAttributes", this.hasNonKeyAttributes() ? this.nonKeyAttributes() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProjectionType": {
                return Optional.ofNullable(clazz.cast(this.projectionTypeAsString()));
            }
            case "NonKeyAttributes": {
                return Optional.ofNullable(clazz.cast(this.nonKeyAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Projection, T> g) {
        return obj -> g.apply((Projection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String projectionType;
        private List<String> nonKeyAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Projection model) {
            this.projectionType(model.projectionType);
            this.nonKeyAttributes(model.nonKeyAttributes);
        }

        public final String getProjectionType() {
            return this.projectionType;
        }

        @Override
        public final Builder projectionType(String projectionType) {
            this.projectionType = projectionType;
            return this;
        }

        @Override
        public final Builder projectionType(ProjectionType projectionType) {
            this.projectionType(projectionType == null ? null : projectionType.toString());
            return this;
        }

        public final void setProjectionType(String projectionType) {
            this.projectionType = projectionType;
        }

        public final Collection<String> getNonKeyAttributes() {
            if (this.nonKeyAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nonKeyAttributes;
        }

        @Override
        public final Builder nonKeyAttributes(Collection<String> nonKeyAttributes) {
            this.nonKeyAttributes = NonKeyAttributeNameListCopier.copy(nonKeyAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nonKeyAttributes(String ... nonKeyAttributes) {
            this.nonKeyAttributes(Arrays.asList(nonKeyAttributes));
            return this;
        }

        public final void setNonKeyAttributes(Collection<String> nonKeyAttributes) {
            this.nonKeyAttributes = NonKeyAttributeNameListCopier.copy(nonKeyAttributes);
        }

        public Projection build() {
            return new Projection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Projection> {
        public Builder projectionType(String var1);

        public Builder projectionType(ProjectionType var1);

        public Builder nonKeyAttributes(Collection<String> var1);

        public Builder nonKeyAttributes(String ... var1);
    }
}

