/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalOperator;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeValueMapCopier;
import software.amazon.awssdk.services.dynamodb.model.FilterConditionMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.Select;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, ScanRequest> {
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScanRequest.getter(ScanRequest::tableName)).setter(ScanRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScanRequest.getter(ScanRequest::indexName)).setter(ScanRequest.setter(Builder::indexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexName").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_TO_GET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ScanRequest.getter(ScanRequest::attributesToGet)).setter(ScanRequest.setter(Builder::attributesToGet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToGet").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScanRequest.getter(ScanRequest::limit)).setter(ScanRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> SELECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScanRequest.getter(ScanRequest::selectAsString)).setter(ScanRequest.setter(Builder::select)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Select").build()}).build();
    private static final SdkField<Map<String, Condition>> SCAN_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ScanRequest.getter(ScanRequest::scanFilter)).setter(ScanRequest.setter(Builder::scanFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanFilter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Condition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONDITIONAL_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScanRequest.getter(ScanRequest::conditionalOperatorAsString)).setter(ScanRequest.setter(Builder::conditionalOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalOperator").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> EXCLUSIVE_START_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ScanRequest.getter(ScanRequest::exclusiveStartKey)).setter(ScanRequest.setter(Builder::exclusiveStartKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveStartKey").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RETURN_CONSUMED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScanRequest.getter(ScanRequest::returnConsumedCapacityAsString)).setter(ScanRequest.setter(Builder::returnConsumedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnConsumedCapacity").build()}).build();
    private static final SdkField<Integer> TOTAL_SEGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScanRequest.getter(ScanRequest::totalSegments)).setter(ScanRequest.setter(Builder::totalSegments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSegments").build()}).build();
    private static final SdkField<Integer> SEGMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ScanRequest.getter(ScanRequest::segment)).setter(ScanRequest.setter(Builder::segment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Segment").build()}).build();
    private static final SdkField<String> PROJECTION_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScanRequest.getter(ScanRequest::projectionExpression)).setter(ScanRequest.setter(Builder::projectionExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectionExpression").build()}).build();
    private static final SdkField<String> FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ScanRequest.getter(ScanRequest::filterExpression)).setter(ScanRequest.setter(Builder::filterExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterExpression").build()}).build();
    private static final SdkField<Map<String, String>> EXPRESSION_ATTRIBUTE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ScanRequest.getter(ScanRequest::expressionAttributeNames)).setter(ScanRequest.setter(Builder::expressionAttributeNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeNames").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AttributeValue>> EXPRESSION_ATTRIBUTE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ScanRequest.getter(ScanRequest::expressionAttributeValues)).setter(ScanRequest.setter(Builder::expressionAttributeValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpressionAttributeValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> CONSISTENT_READ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ScanRequest.getter(ScanRequest::consistentRead)).setter(ScanRequest.setter(Builder::consistentRead)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistentRead").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_NAME_FIELD, INDEX_NAME_FIELD, ATTRIBUTES_TO_GET_FIELD, LIMIT_FIELD, SELECT_FIELD, SCAN_FILTER_FIELD, CONDITIONAL_OPERATOR_FIELD, EXCLUSIVE_START_KEY_FIELD, RETURN_CONSUMED_CAPACITY_FIELD, TOTAL_SEGMENTS_FIELD, SEGMENT_FIELD, PROJECTION_EXPRESSION_FIELD, FILTER_EXPRESSION_FIELD, EXPRESSION_ATTRIBUTE_NAMES_FIELD, EXPRESSION_ATTRIBUTE_VALUES_FIELD, CONSISTENT_READ_FIELD));
    private final String tableName;
    private final String indexName;
    private final List<String> attributesToGet;
    private final Integer limit;
    private final String select;
    private final Map<String, Condition> scanFilter;
    private final String conditionalOperator;
    private final Map<String, AttributeValue> exclusiveStartKey;
    private final String returnConsumedCapacity;
    private final Integer totalSegments;
    private final Integer segment;
    private final String projectionExpression;
    private final String filterExpression;
    private final Map<String, String> expressionAttributeNames;
    private final Map<String, AttributeValue> expressionAttributeValues;
    private final Boolean consistentRead;

    private ScanRequest(BuilderImpl builder) {
        super(builder);
        this.tableName = builder.tableName;
        this.indexName = builder.indexName;
        this.attributesToGet = builder.attributesToGet;
        this.limit = builder.limit;
        this.select = builder.select;
        this.scanFilter = builder.scanFilter;
        this.conditionalOperator = builder.conditionalOperator;
        this.exclusiveStartKey = builder.exclusiveStartKey;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.totalSegments = builder.totalSegments;
        this.segment = builder.segment;
        this.projectionExpression = builder.projectionExpression;
        this.filterExpression = builder.filterExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
        this.expressionAttributeValues = builder.expressionAttributeValues;
        this.consistentRead = builder.consistentRead;
    }

    public String tableName() {
        return this.tableName;
    }

    public String indexName() {
        return this.indexName;
    }

    public boolean hasAttributesToGet() {
        return this.attributesToGet != null && !(this.attributesToGet instanceof SdkAutoConstructList);
    }

    public List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public Integer limit() {
        return this.limit;
    }

    public Select select() {
        return Select.fromValue(this.select);
    }

    public String selectAsString() {
        return this.select;
    }

    public boolean hasScanFilter() {
        return this.scanFilter != null && !(this.scanFilter instanceof SdkAutoConstructMap);
    }

    public Map<String, Condition> scanFilter() {
        return this.scanFilter;
    }

    public ConditionalOperator conditionalOperator() {
        return ConditionalOperator.fromValue(this.conditionalOperator);
    }

    public String conditionalOperatorAsString() {
        return this.conditionalOperator;
    }

    public boolean hasExclusiveStartKey() {
        return this.exclusiveStartKey != null && !(this.exclusiveStartKey instanceof SdkAutoConstructMap);
    }

    public Map<String, AttributeValue> exclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityAsString() {
        return this.returnConsumedCapacity;
    }

    public Integer totalSegments() {
        return this.totalSegments;
    }

    public Integer segment() {
        return this.segment;
    }

    public String projectionExpression() {
        return this.projectionExpression;
    }

    public String filterExpression() {
        return this.filterExpression;
    }

    public boolean hasExpressionAttributeNames() {
        return this.expressionAttributeNames != null && !(this.expressionAttributeNames instanceof SdkAutoConstructMap);
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public boolean hasExpressionAttributeValues() {
        return this.expressionAttributeValues != null && !(this.expressionAttributeValues instanceof SdkAutoConstructMap);
    }

    public Map<String, AttributeValue> expressionAttributeValues() {
        return this.expressionAttributeValues;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesToGet());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.exclusiveStartKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSegments());
        hashCode = 31 * hashCode + Objects.hashCode(this.segment());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistentRead());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanRequest)) {
            return false;
        }
        ScanRequest other = (ScanRequest)((Object)obj);
        return Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.attributesToGet(), other.attributesToGet()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.selectAsString(), other.selectAsString()) && Objects.equals(this.scanFilter(), other.scanFilter()) && Objects.equals(this.conditionalOperatorAsString(), other.conditionalOperatorAsString()) && Objects.equals(this.exclusiveStartKey(), other.exclusiveStartKey()) && Objects.equals(this.returnConsumedCapacityAsString(), other.returnConsumedCapacityAsString()) && Objects.equals(this.totalSegments(), other.totalSegments()) && Objects.equals(this.segment(), other.segment()) && Objects.equals(this.projectionExpression(), other.projectionExpression()) && Objects.equals(this.filterExpression(), other.filterExpression()) && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames()) && Objects.equals(this.expressionAttributeValues(), other.expressionAttributeValues()) && Objects.equals(this.consistentRead(), other.consistentRead());
    }

    public String toString() {
        return ToString.builder((String)"ScanRequest").add("TableName", (Object)this.tableName()).add("IndexName", (Object)this.indexName()).add("AttributesToGet", this.attributesToGet()).add("Limit", (Object)this.limit()).add("Select", (Object)this.selectAsString()).add("ScanFilter", this.scanFilter()).add("ConditionalOperator", (Object)this.conditionalOperatorAsString()).add("ExclusiveStartKey", this.exclusiveStartKey()).add("ReturnConsumedCapacity", (Object)this.returnConsumedCapacityAsString()).add("TotalSegments", (Object)this.totalSegments()).add("Segment", (Object)this.segment()).add("ProjectionExpression", (Object)this.projectionExpression()).add("FilterExpression", (Object)this.filterExpression()).add("ExpressionAttributeNames", this.expressionAttributeNames()).add("ExpressionAttributeValues", this.expressionAttributeValues()).add("ConsistentRead", (Object)this.consistentRead()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "AttributesToGet": {
                return Optional.ofNullable(clazz.cast(this.attributesToGet()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "Select": {
                return Optional.ofNullable(clazz.cast(this.selectAsString()));
            }
            case "ScanFilter": {
                return Optional.ofNullable(clazz.cast(this.scanFilter()));
            }
            case "ConditionalOperator": {
                return Optional.ofNullable(clazz.cast(this.conditionalOperatorAsString()));
            }
            case "ExclusiveStartKey": {
                return Optional.ofNullable(clazz.cast(this.exclusiveStartKey()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.ofNullable(clazz.cast(this.returnConsumedCapacityAsString()));
            }
            case "TotalSegments": {
                return Optional.ofNullable(clazz.cast(this.totalSegments()));
            }
            case "Segment": {
                return Optional.ofNullable(clazz.cast(this.segment()));
            }
            case "ProjectionExpression": {
                return Optional.ofNullable(clazz.cast(this.projectionExpression()));
            }
            case "FilterExpression": {
                return Optional.ofNullable(clazz.cast(this.filterExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeNames()));
            }
            case "ExpressionAttributeValues": {
                return Optional.ofNullable(clazz.cast(this.expressionAttributeValues()));
            }
            case "ConsistentRead": {
                return Optional.ofNullable(clazz.cast(this.consistentRead()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScanRequest, T> g) {
        return obj -> g.apply((ScanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String tableName;
        private String indexName;
        private List<String> attributesToGet = DefaultSdkAutoConstructList.getInstance();
        private Integer limit;
        private String select;
        private Map<String, Condition> scanFilter = DefaultSdkAutoConstructMap.getInstance();
        private String conditionalOperator;
        private Map<String, AttributeValue> exclusiveStartKey = DefaultSdkAutoConstructMap.getInstance();
        private String returnConsumedCapacity;
        private Integer totalSegments;
        private Integer segment;
        private String projectionExpression;
        private String filterExpression;
        private Map<String, String> expressionAttributeNames = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeValue> expressionAttributeValues = DefaultSdkAutoConstructMap.getInstance();
        private Boolean consistentRead;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanRequest model) {
            super(model);
            this.tableName(model.tableName);
            this.indexName(model.indexName);
            this.attributesToGet(model.attributesToGet);
            this.limit(model.limit);
            this.select(model.select);
            this.scanFilter(model.scanFilter);
            this.conditionalOperator(model.conditionalOperator);
            this.exclusiveStartKey(model.exclusiveStartKey);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.totalSegments(model.totalSegments);
            this.segment(model.segment);
            this.projectionExpression(model.projectionExpression);
            this.filterExpression(model.filterExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
            this.expressionAttributeValues(model.expressionAttributeValues);
            this.consistentRead(model.consistentRead);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<String> getAttributesToGet() {
            return this.attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        public final String getSelectAsString() {
            return this.select;
        }

        @Override
        public final Builder select(String select) {
            this.select = select;
            return this;
        }

        @Override
        public final Builder select(Select select) {
            this.select(select == null ? null : select.toString());
            return this;
        }

        public final void setSelect(String select) {
            this.select = select;
        }

        public final Map<String, Condition.Builder> getScanFilter() {
            return this.scanFilter != null ? CollectionUtils.mapValues(this.scanFilter, Condition::toBuilder) : null;
        }

        @Override
        public final Builder scanFilter(Map<String, Condition> scanFilter) {
            this.scanFilter = FilterConditionMapCopier.copy(scanFilter);
            return this;
        }

        public final void setScanFilter(Map<String, Condition.BuilderImpl> scanFilter) {
            this.scanFilter = FilterConditionMapCopier.copyFromBuilder(scanFilter);
        }

        public final String getConditionalOperatorAsString() {
            return this.conditionalOperator;
        }

        @Override
        public final Builder conditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
            return this;
        }

        @Override
        public final Builder conditionalOperator(ConditionalOperator conditionalOperator) {
            this.conditionalOperator(conditionalOperator == null ? null : conditionalOperator.toString());
            return this;
        }

        public final void setConditionalOperator(String conditionalOperator) {
            this.conditionalOperator = conditionalOperator;
        }

        public final Map<String, AttributeValue.Builder> getExclusiveStartKey() {
            return this.exclusiveStartKey != null ? CollectionUtils.mapValues(this.exclusiveStartKey, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder exclusiveStartKey(Map<String, AttributeValue> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copy(exclusiveStartKey);
            return this;
        }

        public final void setExclusiveStartKey(Map<String, AttributeValue.BuilderImpl> exclusiveStartKey) {
            this.exclusiveStartKey = KeyCopier.copyFromBuilder(exclusiveStartKey);
        }

        public final String getReturnConsumedCapacityAsString() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity == null ? null : returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final Integer getTotalSegments() {
            return this.totalSegments;
        }

        @Override
        public final Builder totalSegments(Integer totalSegments) {
            this.totalSegments = totalSegments;
            return this;
        }

        public final void setTotalSegments(Integer totalSegments) {
            this.totalSegments = totalSegments;
        }

        public final Integer getSegment() {
            return this.segment;
        }

        @Override
        public final Builder segment(Integer segment) {
            this.segment = segment;
            return this;
        }

        public final void setSegment(Integer segment) {
            this.segment = segment;
        }

        public final String getProjectionExpression() {
            return this.projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final String getFilterExpression() {
            return this.filterExpression;
        }

        @Override
        public final Builder filterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        public final void setFilterExpression(String filterExpression) {
            this.filterExpression = filterExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public final Map<String, AttributeValue.Builder> getExpressionAttributeValues() {
            return this.expressionAttributeValues != null ? CollectionUtils.mapValues(this.expressionAttributeValues, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder expressionAttributeValues(Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copy(expressionAttributeValues);
            return this;
        }

        public final void setExpressionAttributeValues(Map<String, AttributeValue.BuilderImpl> expressionAttributeValues) {
            this.expressionAttributeValues = ExpressionAttributeValueMapCopier.copyFromBuilder(expressionAttributeValues);
        }

        public final Boolean getConsistentRead() {
            return this.consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ScanRequest build() {
            return new ScanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ScanRequest> {
        public Builder tableName(String var1);

        public Builder indexName(String var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder limit(Integer var1);

        public Builder select(String var1);

        public Builder select(Select var1);

        public Builder scanFilter(Map<String, Condition> var1);

        public Builder conditionalOperator(String var1);

        public Builder conditionalOperator(ConditionalOperator var1);

        public Builder exclusiveStartKey(Map<String, AttributeValue> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder totalSegments(Integer var1);

        public Builder segment(Integer var1);

        public Builder projectionExpression(String var1);

        public Builder filterExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);

        public Builder expressionAttributeValues(Map<String, AttributeValue> var1);

        public Builder consistentRead(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

