/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbRequest;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndex;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreTableFromBackupRequest
extends DynamoDbRequest
implements ToCopyableBuilder<Builder, RestoreTableFromBackupRequest> {
    private static final SdkField<String> TARGET_TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::targetTableName)).setter(RestoreTableFromBackupRequest.setter(Builder::targetTableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTableName").build()}).build();
    private static final SdkField<String> BACKUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::backupArn)).setter(RestoreTableFromBackupRequest.setter(Builder::backupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupArn").build()}).build();
    private static final SdkField<String> BILLING_MODE_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::billingModeOverrideAsString)).setter(RestoreTableFromBackupRequest.setter(Builder::billingModeOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingModeOverride").build()}).build();
    private static final SdkField<List<GlobalSecondaryIndex>> GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::globalSecondaryIndexOverride)).setter(RestoreTableFromBackupRequest.setter(Builder::globalSecondaryIndexOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalSecondaryIndexOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LocalSecondaryIndex>> LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::localSecondaryIndexOverride)).setter(RestoreTableFromBackupRequest.setter(Builder::localSecondaryIndexOverride)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalSecondaryIndexOverride").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocalSecondaryIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProvisionedThroughput> PROVISIONED_THROUGHPUT_OVERRIDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RestoreTableFromBackupRequest.getter(RestoreTableFromBackupRequest::provisionedThroughputOverride)).setter(RestoreTableFromBackupRequest.setter(Builder::provisionedThroughputOverride)).constructor(ProvisionedThroughput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedThroughputOverride").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_TABLE_NAME_FIELD, BACKUP_ARN_FIELD, BILLING_MODE_OVERRIDE_FIELD, GLOBAL_SECONDARY_INDEX_OVERRIDE_FIELD, LOCAL_SECONDARY_INDEX_OVERRIDE_FIELD, PROVISIONED_THROUGHPUT_OVERRIDE_FIELD));
    private final String targetTableName;
    private final String backupArn;
    private final String billingModeOverride;
    private final List<GlobalSecondaryIndex> globalSecondaryIndexOverride;
    private final List<LocalSecondaryIndex> localSecondaryIndexOverride;
    private final ProvisionedThroughput provisionedThroughputOverride;

    private RestoreTableFromBackupRequest(BuilderImpl builder) {
        super(builder);
        this.targetTableName = builder.targetTableName;
        this.backupArn = builder.backupArn;
        this.billingModeOverride = builder.billingModeOverride;
        this.globalSecondaryIndexOverride = builder.globalSecondaryIndexOverride;
        this.localSecondaryIndexOverride = builder.localSecondaryIndexOverride;
        this.provisionedThroughputOverride = builder.provisionedThroughputOverride;
    }

    public String targetTableName() {
        return this.targetTableName;
    }

    public String backupArn() {
        return this.backupArn;
    }

    public BillingMode billingModeOverride() {
        return BillingMode.fromValue(this.billingModeOverride);
    }

    public String billingModeOverrideAsString() {
        return this.billingModeOverride;
    }

    public List<GlobalSecondaryIndex> globalSecondaryIndexOverride() {
        return this.globalSecondaryIndexOverride;
    }

    public List<LocalSecondaryIndex> localSecondaryIndexOverride() {
        return this.localSecondaryIndexOverride;
    }

    public ProvisionedThroughput provisionedThroughputOverride() {
        return this.provisionedThroughputOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingModeOverrideAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSecondaryIndexOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.localSecondaryIndexOverride());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughputOverride());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTableFromBackupRequest)) {
            return false;
        }
        RestoreTableFromBackupRequest other = (RestoreTableFromBackupRequest)((Object)obj);
        return Objects.equals(this.targetTableName(), other.targetTableName()) && Objects.equals(this.backupArn(), other.backupArn()) && Objects.equals(this.billingModeOverrideAsString(), other.billingModeOverrideAsString()) && Objects.equals(this.globalSecondaryIndexOverride(), other.globalSecondaryIndexOverride()) && Objects.equals(this.localSecondaryIndexOverride(), other.localSecondaryIndexOverride()) && Objects.equals(this.provisionedThroughputOverride(), other.provisionedThroughputOverride());
    }

    public String toString() {
        return ToString.builder((String)"RestoreTableFromBackupRequest").add("TargetTableName", (Object)this.targetTableName()).add("BackupArn", (Object)this.backupArn()).add("BillingModeOverride", (Object)this.billingModeOverrideAsString()).add("GlobalSecondaryIndexOverride", this.globalSecondaryIndexOverride()).add("LocalSecondaryIndexOverride", this.localSecondaryIndexOverride()).add("ProvisionedThroughputOverride", (Object)this.provisionedThroughputOverride()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetTableName": {
                return Optional.ofNullable(clazz.cast(this.targetTableName()));
            }
            case "BackupArn": {
                return Optional.ofNullable(clazz.cast(this.backupArn()));
            }
            case "BillingModeOverride": {
                return Optional.ofNullable(clazz.cast(this.billingModeOverrideAsString()));
            }
            case "GlobalSecondaryIndexOverride": {
                return Optional.ofNullable(clazz.cast(this.globalSecondaryIndexOverride()));
            }
            case "LocalSecondaryIndexOverride": {
                return Optional.ofNullable(clazz.cast(this.localSecondaryIndexOverride()));
            }
            case "ProvisionedThroughputOverride": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughputOverride()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreTableFromBackupRequest, T> g) {
        return obj -> g.apply((RestoreTableFromBackupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DynamoDbRequest.BuilderImpl
    implements Builder {
        private String targetTableName;
        private String backupArn;
        private String billingModeOverride;
        private List<GlobalSecondaryIndex> globalSecondaryIndexOverride = DefaultSdkAutoConstructList.getInstance();
        private List<LocalSecondaryIndex> localSecondaryIndexOverride = DefaultSdkAutoConstructList.getInstance();
        private ProvisionedThroughput provisionedThroughputOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTableFromBackupRequest model) {
            super(model);
            this.targetTableName(model.targetTableName);
            this.backupArn(model.backupArn);
            this.billingModeOverride(model.billingModeOverride);
            this.globalSecondaryIndexOverride(model.globalSecondaryIndexOverride);
            this.localSecondaryIndexOverride(model.localSecondaryIndexOverride);
            this.provisionedThroughputOverride(model.provisionedThroughputOverride);
        }

        public final String getTargetTableName() {
            return this.targetTableName;
        }

        @Override
        public final Builder targetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
            return this;
        }

        public final void setTargetTableName(String targetTableName) {
            this.targetTableName = targetTableName;
        }

        public final String getBackupArn() {
            return this.backupArn;
        }

        @Override
        public final Builder backupArn(String backupArn) {
            this.backupArn = backupArn;
            return this;
        }

        public final void setBackupArn(String backupArn) {
            this.backupArn = backupArn;
        }

        public final String getBillingModeOverrideAsString() {
            return this.billingModeOverride;
        }

        @Override
        public final Builder billingModeOverride(String billingModeOverride) {
            this.billingModeOverride = billingModeOverride;
            return this;
        }

        @Override
        public final Builder billingModeOverride(BillingMode billingModeOverride) {
            this.billingModeOverride(billingModeOverride == null ? null : billingModeOverride.toString());
            return this;
        }

        public final void setBillingModeOverride(String billingModeOverride) {
            this.billingModeOverride = billingModeOverride;
        }

        public final Collection<GlobalSecondaryIndex.Builder> getGlobalSecondaryIndexOverride() {
            return this.globalSecondaryIndexOverride != null ? (Collection)this.globalSecondaryIndexOverride.stream().map(GlobalSecondaryIndex::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexOverride(Collection<GlobalSecondaryIndex> globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride = GlobalSecondaryIndexListCopier.copy(globalSecondaryIndexOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexOverride(GlobalSecondaryIndex ... globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride(Arrays.asList(globalSecondaryIndexOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexOverride(Consumer<GlobalSecondaryIndex.Builder> ... globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride(Stream.of(globalSecondaryIndexOverride).map(c -> (GlobalSecondaryIndex)((GlobalSecondaryIndex.Builder)GlobalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGlobalSecondaryIndexOverride(Collection<GlobalSecondaryIndex.BuilderImpl> globalSecondaryIndexOverride) {
            this.globalSecondaryIndexOverride = GlobalSecondaryIndexListCopier.copyFromBuilder(globalSecondaryIndexOverride);
        }

        public final Collection<LocalSecondaryIndex.Builder> getLocalSecondaryIndexOverride() {
            return this.localSecondaryIndexOverride != null ? (Collection)this.localSecondaryIndexOverride.stream().map(LocalSecondaryIndex::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localSecondaryIndexOverride(Collection<LocalSecondaryIndex> localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride = LocalSecondaryIndexListCopier.copy(localSecondaryIndexOverride);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexOverride(LocalSecondaryIndex ... localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride(Arrays.asList(localSecondaryIndexOverride));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexOverride(Consumer<LocalSecondaryIndex.Builder> ... localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride(Stream.of(localSecondaryIndexOverride).map(c -> (LocalSecondaryIndex)((LocalSecondaryIndex.Builder)LocalSecondaryIndex.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLocalSecondaryIndexOverride(Collection<LocalSecondaryIndex.BuilderImpl> localSecondaryIndexOverride) {
            this.localSecondaryIndexOverride = LocalSecondaryIndexListCopier.copyFromBuilder(localSecondaryIndexOverride);
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughputOverride() {
            return this.provisionedThroughputOverride != null ? this.provisionedThroughputOverride.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughputOverride(ProvisionedThroughput provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride;
            return this;
        }

        public final void setProvisionedThroughputOverride(ProvisionedThroughput.BuilderImpl provisionedThroughputOverride) {
            this.provisionedThroughputOverride = provisionedThroughputOverride != null ? provisionedThroughputOverride.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreTableFromBackupRequest build() {
            return new RestoreTableFromBackupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DynamoDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreTableFromBackupRequest> {
        public Builder targetTableName(String var1);

        public Builder backupArn(String var1);

        public Builder billingModeOverride(String var1);

        public Builder billingModeOverride(BillingMode var1);

        public Builder globalSecondaryIndexOverride(Collection<GlobalSecondaryIndex> var1);

        public Builder globalSecondaryIndexOverride(GlobalSecondaryIndex ... var1);

        public Builder globalSecondaryIndexOverride(Consumer<GlobalSecondaryIndex.Builder> ... var1);

        public Builder localSecondaryIndexOverride(Collection<LocalSecondaryIndex> var1);

        public Builder localSecondaryIndexOverride(LocalSecondaryIndex ... var1);

        public Builder localSecondaryIndexOverride(Consumer<LocalSecondaryIndex.Builder> ... var1);

        public Builder provisionedThroughputOverride(ProvisionedThroughput var1);

        default public Builder provisionedThroughputOverride(Consumer<ProvisionedThroughput.Builder> provisionedThroughputOverride) {
            return this.provisionedThroughputOverride((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughputOverride)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

