/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.SourceTableDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SourceTableDetailsMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").isBinary(false).build();
    private static final MarshallingInfo<String> TABLEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableId").isBinary(false).build();
    private static final MarshallingInfo<String> TABLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableArn").isBinary(false).build();
    private static final MarshallingInfo<Long> TABLESIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableSizeBytes").isBinary(false).build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").isBinary(false).build();
    private static final MarshallingInfo<Instant> TABLECREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableCreationDateTime").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONEDTHROUGHPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedThroughput").isBinary(false).build();
    private static final MarshallingInfo<Long> ITEMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemCount").isBinary(false).build();
    private static final SourceTableDetailsMarshaller INSTANCE = new SourceTableDetailsMarshaller();

    private SourceTableDetailsMarshaller() {
    }

    public static SourceTableDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SourceTableDetails sourceTableDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sourceTableDetails, (String)"sourceTableDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sourceTableDetails.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.tableId(), TABLEID_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.tableArn(), TABLEARN_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.tableSizeBytes(), TABLESIZEBYTES_BINDING);
            protocolMarshaller.marshall(sourceTableDetails.keySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.tableCreationDateTime(), TABLECREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.provisionedThroughput(), PROVISIONEDTHROUGHPUT_BINDING);
            protocolMarshaller.marshall((Object)sourceTableDetails.itemCount(), ITEMCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

