/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.dynamodb.model.DescribeGlobalTableRequest;
import software.amazon.awssdk.services.dynamodb.transform.DescribeGlobalTableRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeGlobalTableRequestMarshaller
implements Marshaller<Request<DescribeGlobalTableRequest>, DescribeGlobalTableRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("DynamoDB_20120810.DescribeGlobalTable").serviceName("DynamoDB").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public DescribeGlobalTableRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeGlobalTableRequest> marshall(DescribeGlobalTableRequest describeGlobalTableRequest) {
        Validate.paramNotNull((Object)((Object)describeGlobalTableRequest), (String)"describeGlobalTableRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)describeGlobalTableRequest);
            protocolMarshaller.startMarshalling();
            DescribeGlobalTableRequestModelMarshaller.getInstance().marshall(describeGlobalTableRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

