/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.transform.UpdateGlobalSecondaryIndexActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGlobalSecondaryIndexAction
implements StructuredPojo,
ToCopyableBuilder<Builder, UpdateGlobalSecondaryIndexAction> {
    private final String indexName;
    private final ProvisionedThroughput provisionedThroughput;

    private UpdateGlobalSecondaryIndexAction(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.provisionedThroughput = builder.provisionedThroughput;
    }

    public String indexName() {
        return this.indexName;
    }

    public ProvisionedThroughput provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGlobalSecondaryIndexAction)) {
            return false;
        }
        UpdateGlobalSecondaryIndexAction other = (UpdateGlobalSecondaryIndexAction)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGlobalSecondaryIndexAction").add("IndexName", (Object)this.indexName()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpdateGlobalSecondaryIndexActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private ProvisionedThroughput provisionedThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGlobalSecondaryIndexAction model) {
            this.indexName(model.indexName);
            this.provisionedThroughput(model.provisionedThroughput);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final ProvisionedThroughput.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughput provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughput.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public UpdateGlobalSecondaryIndexAction build() {
            return new UpdateGlobalSecondaryIndexAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateGlobalSecondaryIndexAction> {
        public Builder indexName(String var1);

        public Builder provisionedThroughput(ProvisionedThroughput var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughput.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughput)((ProvisionedThroughput.Builder)ProvisionedThroughput.builder().applyMutation(provisionedThroughput)).build());
        }
    }
}

