/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.SSEDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SSEDescriptionMarshaller {
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final SSEDescriptionMarshaller INSTANCE = new SSEDescriptionMarshaller();

    private SSEDescriptionMarshaller() {
    }

    public static SSEDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SSEDescription sseDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)sseDescription, (String)"sseDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)sseDescription.statusAsString(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

