/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProjectionMarshaller {
    private static final MarshallingInfo<String> PROJECTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProjectionType").isBinary(false).build();
    private static final MarshallingInfo<List> NONKEYATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NonKeyAttributes").isBinary(false).build();
    private static final ProjectionMarshaller INSTANCE = new ProjectionMarshaller();

    private ProjectionMarshaller() {
    }

    public static ProjectionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Projection projection, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)projection, (String)"projection");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)projection.projectionTypeAsString(), PROJECTIONTYPE_BINDING);
            protocolMarshaller.marshall(projection.nonKeyAttributes(), NONKEYATTRIBUTES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

