/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GlobalSecondaryIndexDescriptionMarshaller {
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").isBinary(false).build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROJECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Projection").isBinary(false).build();
    private static final MarshallingInfo<String> INDEXSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexStatus").isBinary(false).build();
    private static final MarshallingInfo<Boolean> BACKFILLING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Backfilling").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONEDTHROUGHPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedThroughput").isBinary(false).build();
    private static final MarshallingInfo<Long> INDEXSIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexSizeBytes").isBinary(false).build();
    private static final MarshallingInfo<Long> ITEMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemCount").isBinary(false).build();
    private static final MarshallingInfo<String> INDEXARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexArn").isBinary(false).build();
    private static final GlobalSecondaryIndexDescriptionMarshaller INSTANCE = new GlobalSecondaryIndexDescriptionMarshaller();

    private GlobalSecondaryIndexDescriptionMarshaller() {
    }

    public static GlobalSecondaryIndexDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GlobalSecondaryIndexDescription globalSecondaryIndexDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)globalSecondaryIndexDescription, (String)"globalSecondaryIndexDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall(globalSecondaryIndexDescription.keySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.projection(), PROJECTION_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.indexStatusAsString(), INDEXSTATUS_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.backfilling(), BACKFILLING_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.provisionedThroughput(), PROVISIONEDTHROUGHPUT_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.indexSizeBytes(), INDEXSIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.itemCount(), ITEMCOUNT_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.indexArn(), INDEXARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

