/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.BackupDescription;
import software.amazon.awssdk.services.dynamodb.transform.BackupDetailsUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.SourceTableDetailsUnmarshaller;
import software.amazon.awssdk.services.dynamodb.transform.SourceTableFeatureDetailsUnmarshaller;

public class BackupDescriptionUnmarshaller
implements Unmarshaller<BackupDescription, JsonUnmarshallerContext> {
    private static final BackupDescriptionUnmarshaller INSTANCE = new BackupDescriptionUnmarshaller();

    public BackupDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        BackupDescription.Builder backupDescriptionBuilder = BackupDescription.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("BackupDetails", targetDepth)) {
                    context.nextToken();
                    backupDescriptionBuilder.backupDetails(BackupDetailsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SourceTableDetails", targetDepth)) {
                    context.nextToken();
                    backupDescriptionBuilder.sourceTableDetails(SourceTableDetailsUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SourceTableFeatureDetails", targetDepth)) {
                    context.nextToken();
                    backupDescriptionBuilder.sourceTableFeatureDetails(SourceTableFeatureDetailsUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (BackupDescription)backupDescriptionBuilder.build();
    }

    public static BackupDescriptionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

