/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.TimeToLiveSpecificationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeToLiveSpecification
implements StructuredPojo,
ToCopyableBuilder<Builder, TimeToLiveSpecification> {
    private final Boolean enabled;
    private final String attributeName;

    private TimeToLiveSpecification(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.attributeName = builder.attributeName;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeToLiveSpecification)) {
            return false;
        }
        TimeToLiveSpecification other = (TimeToLiveSpecification)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.attributeName(), other.attributeName());
    }

    public String toString() {
        return ToString.builder((String)"TimeToLiveSpecification").add("Enabled", (Object)this.enabled()).add("AttributeName", (Object)this.attributeName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "AttributeName": {
                return Optional.ofNullable(clazz.cast(this.attributeName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeToLiveSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeToLiveSpecification model) {
            this.enabled(model.enabled);
            this.attributeName(model.attributeName);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public TimeToLiveSpecification build() {
            return new TimeToLiveSpecification(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimeToLiveSpecification> {
        public Builder enabled(Boolean var1);

        public Builder attributeName(String var1);
    }
}

