/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.transform.StreamRecordMarshaller;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StreamRecord
implements StructuredPojo,
ToCopyableBuilder<Builder, StreamRecord> {
    private final Instant approximateCreationDateTime;
    private final Map<String, AttributeValue> keys;
    private final Map<String, AttributeValue> newImage;
    private final Map<String, AttributeValue> oldImage;
    private final String sequenceNumber;
    private final Long sizeBytes;
    private final String streamViewType;

    private StreamRecord(BuilderImpl builder) {
        this.approximateCreationDateTime = builder.approximateCreationDateTime;
        this.keys = builder.keys;
        this.newImage = builder.newImage;
        this.oldImage = builder.oldImage;
        this.sequenceNumber = builder.sequenceNumber;
        this.sizeBytes = builder.sizeBytes;
        this.streamViewType = builder.streamViewType;
    }

    public Instant approximateCreationDateTime() {
        return this.approximateCreationDateTime;
    }

    public Map<String, AttributeValue> keys() {
        return this.keys;
    }

    public Map<String, AttributeValue> newImage() {
        return this.newImage;
    }

    public Map<String, AttributeValue> oldImage() {
        return this.oldImage;
    }

    public String sequenceNumber() {
        return this.sequenceNumber;
    }

    public Long sizeBytes() {
        return this.sizeBytes;
    }

    public StreamViewType streamViewType() {
        return StreamViewType.fromValue(this.streamViewType);
    }

    public String streamViewTypeAsString() {
        return this.streamViewType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateCreationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.keys());
        hashCode = 31 * hashCode + Objects.hashCode(this.newImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.oldImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamViewTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamRecord)) {
            return false;
        }
        StreamRecord other = (StreamRecord)obj;
        return Objects.equals(this.approximateCreationDateTime(), other.approximateCreationDateTime()) && Objects.equals(this.keys(), other.keys()) && Objects.equals(this.newImage(), other.newImage()) && Objects.equals(this.oldImage(), other.oldImage()) && Objects.equals(this.sequenceNumber(), other.sequenceNumber()) && Objects.equals(this.sizeBytes(), other.sizeBytes()) && Objects.equals(this.streamViewTypeAsString(), other.streamViewTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"StreamRecord").add("ApproximateCreationDateTime", (Object)this.approximateCreationDateTime()).add("Keys", this.keys()).add("NewImage", this.newImage()).add("OldImage", this.oldImage()).add("SequenceNumber", (Object)this.sequenceNumber()).add("SizeBytes", (Object)this.sizeBytes()).add("StreamViewType", (Object)this.streamViewTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApproximateCreationDateTime": {
                return Optional.ofNullable(clazz.cast(this.approximateCreationDateTime()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "NewImage": {
                return Optional.ofNullable(clazz.cast(this.newImage()));
            }
            case "OldImage": {
                return Optional.ofNullable(clazz.cast(this.oldImage()));
            }
            case "SequenceNumber": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumber()));
            }
            case "SizeBytes": {
                return Optional.ofNullable(clazz.cast(this.sizeBytes()));
            }
            case "StreamViewType": {
                return Optional.ofNullable(clazz.cast(this.streamViewTypeAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StreamRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant approximateCreationDateTime;
        private Map<String, AttributeValue> keys = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeValue> newImage = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AttributeValue> oldImage = DefaultSdkAutoConstructMap.getInstance();
        private String sequenceNumber;
        private Long sizeBytes;
        private String streamViewType;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamRecord model) {
            this.approximateCreationDateTime(model.approximateCreationDateTime);
            this.keys(model.keys);
            this.newImage(model.newImage);
            this.oldImage(model.oldImage);
            this.sequenceNumber(model.sequenceNumber);
            this.sizeBytes(model.sizeBytes);
            this.streamViewType(model.streamViewType);
        }

        public final Instant getApproximateCreationDateTime() {
            return this.approximateCreationDateTime;
        }

        @Override
        public final Builder approximateCreationDateTime(Instant approximateCreationDateTime) {
            this.approximateCreationDateTime = approximateCreationDateTime;
            return this;
        }

        public final void setApproximateCreationDateTime(Instant approximateCreationDateTime) {
            this.approximateCreationDateTime = approximateCreationDateTime;
        }

        public final Map<String, AttributeValue.Builder> getKeys() {
            return this.keys != null ? CollectionUtils.mapValues(this.keys, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder keys(Map<String, AttributeValue> keys) {
            this.keys = AttributeMapCopier.copy(keys);
            return this;
        }

        public final void setKeys(Map<String, AttributeValue.BuilderImpl> keys) {
            this.keys = AttributeMapCopier.copyFromBuilder(keys);
        }

        public final Map<String, AttributeValue.Builder> getNewImage() {
            return this.newImage != null ? CollectionUtils.mapValues(this.newImage, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder newImage(Map<String, AttributeValue> newImage) {
            this.newImage = AttributeMapCopier.copy(newImage);
            return this;
        }

        public final void setNewImage(Map<String, AttributeValue.BuilderImpl> newImage) {
            this.newImage = AttributeMapCopier.copyFromBuilder(newImage);
        }

        public final Map<String, AttributeValue.Builder> getOldImage() {
            return this.oldImage != null ? CollectionUtils.mapValues(this.oldImage, AttributeValue::toBuilder) : null;
        }

        @Override
        public final Builder oldImage(Map<String, AttributeValue> oldImage) {
            this.oldImage = AttributeMapCopier.copy(oldImage);
            return this;
        }

        public final void setOldImage(Map<String, AttributeValue.BuilderImpl> oldImage) {
            this.oldImage = AttributeMapCopier.copyFromBuilder(oldImage);
        }

        public final String getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public final Builder sequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }

        public final void setSequenceNumber(String sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }

        public final Long getSizeBytes() {
            return this.sizeBytes;
        }

        @Override
        public final Builder sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public final void setSizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public final String getStreamViewType() {
            return this.streamViewType;
        }

        @Override
        public final Builder streamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
            return this;
        }

        @Override
        public final Builder streamViewType(StreamViewType streamViewType) {
            this.streamViewType(streamViewType.toString());
            return this;
        }

        public final void setStreamViewType(String streamViewType) {
            this.streamViewType = streamViewType;
        }

        public StreamRecord build() {
            return new StreamRecord(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StreamRecord> {
        public Builder approximateCreationDateTime(Instant var1);

        public Builder keys(Map<String, AttributeValue> var1);

        public Builder newImage(Map<String, AttributeValue> var1);

        public Builder oldImage(Map<String, AttributeValue> var1);

        public Builder sequenceNumber(String var1);

        public Builder sizeBytes(Long var1);

        public Builder streamViewType(String var1);

        public Builder streamViewType(StreamViewType var1);
    }
}

