/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dynamodb.model.IndexStatus;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.Projection;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.services.dynamodb.transform.GlobalSecondaryIndexDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalSecondaryIndexDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, GlobalSecondaryIndexDescription> {
    private final String indexName;
    private final List<KeySchemaElement> keySchema;
    private final Projection projection;
    private final String indexStatus;
    private final Boolean backfilling;
    private final ProvisionedThroughputDescription provisionedThroughput;
    private final Long indexSizeBytes;
    private final Long itemCount;
    private final String indexArn;

    private GlobalSecondaryIndexDescription(BuilderImpl builder) {
        this.indexName = builder.indexName;
        this.keySchema = builder.keySchema;
        this.projection = builder.projection;
        this.indexStatus = builder.indexStatus;
        this.backfilling = builder.backfilling;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.indexSizeBytes = builder.indexSizeBytes;
        this.itemCount = builder.itemCount;
        this.indexArn = builder.indexArn;
    }

    public String indexName() {
        return this.indexName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public Projection projection() {
        return this.projection;
    }

    public IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public String indexStatusAsString() {
        return this.indexStatus;
    }

    public Boolean backfilling() {
        return this.backfilling;
    }

    public ProvisionedThroughputDescription provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Long indexSizeBytes() {
        return this.indexSizeBytes;
    }

    public Long itemCount() {
        return this.itemCount;
    }

    public String indexArn() {
        return this.indexArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.indexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.projection());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.backfilling());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalSecondaryIndexDescription)) {
            return false;
        }
        GlobalSecondaryIndexDescription other = (GlobalSecondaryIndexDescription)obj;
        return Objects.equals(this.indexName(), other.indexName()) && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.projection(), other.projection()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(this.backfilling(), other.backfilling()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && Objects.equals(this.indexSizeBytes(), other.indexSizeBytes()) && Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.indexArn(), other.indexArn());
    }

    public String toString() {
        return ToString.builder((String)"GlobalSecondaryIndexDescription").add("IndexName", (Object)this.indexName()).add("KeySchema", this.keySchema()).add("Projection", (Object)this.projection()).add("IndexStatus", (Object)this.indexStatusAsString()).add("Backfilling", (Object)this.backfilling()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("IndexSizeBytes", (Object)this.indexSizeBytes()).add("ItemCount", (Object)this.itemCount()).add("IndexArn", (Object)this.indexArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexName": {
                return Optional.ofNullable(clazz.cast(this.indexName()));
            }
            case "KeySchema": {
                return Optional.ofNullable(clazz.cast(this.keySchema()));
            }
            case "Projection": {
                return Optional.ofNullable(clazz.cast(this.projection()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "Backfilling": {
                return Optional.ofNullable(clazz.cast(this.backfilling()));
            }
            case "ProvisionedThroughput": {
                return Optional.ofNullable(clazz.cast(this.provisionedThroughput()));
            }
            case "IndexSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.indexSizeBytes()));
            }
            case "ItemCount": {
                return Optional.ofNullable(clazz.cast(this.itemCount()));
            }
            case "IndexArn": {
                return Optional.ofNullable(clazz.cast(this.indexArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        GlobalSecondaryIndexDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String indexName;
        private List<KeySchemaElement> keySchema = DefaultSdkAutoConstructList.getInstance();
        private Projection projection;
        private String indexStatus;
        private Boolean backfilling;
        private ProvisionedThroughputDescription provisionedThroughput;
        private Long indexSizeBytes;
        private Long itemCount;
        private String indexArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalSecondaryIndexDescription model) {
            this.indexName(model.indexName);
            this.keySchema(model.keySchema);
            this.projection(model.projection);
            this.indexStatus(model.indexStatus);
            this.backfilling(model.backfilling);
            this.provisionedThroughput(model.provisionedThroughput);
            this.indexSizeBytes(model.indexSizeBytes);
            this.itemCount(model.itemCount);
            this.indexArn(model.indexArn);
        }

        public final String getIndexName() {
            return this.indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return this.keySchema != null ? (Collection)this.keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(Consumer<KeySchemaElement.Builder> ... keySchema) {
            this.keySchema(Stream.of(keySchema).map(c -> (KeySchemaElement)((KeySchemaElement.Builder)KeySchemaElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final Projection.Builder getProjection() {
            return this.projection != null ? this.projection.toBuilder() : null;
        }

        @Override
        public final Builder projection(Projection projection) {
            this.projection = projection;
            return this;
        }

        public final void setProjection(Projection.BuilderImpl projection) {
            this.projection = projection != null ? projection.build() : null;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus.toString());
            return this;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        public final Boolean getBackfilling() {
            return this.backfilling;
        }

        @Override
        public final Builder backfilling(Boolean backfilling) {
            this.backfilling = backfilling;
            return this;
        }

        public final void setBackfilling(Boolean backfilling) {
            this.backfilling = backfilling;
        }

        public final ProvisionedThroughputDescription.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughputDescription.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final Long getIndexSizeBytes() {
            return this.indexSizeBytes;
        }

        @Override
        public final Builder indexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
            return this;
        }

        public final void setIndexSizeBytes(Long indexSizeBytes) {
            this.indexSizeBytes = indexSizeBytes;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public final String getIndexArn() {
            return this.indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        public GlobalSecondaryIndexDescription build() {
            return new GlobalSecondaryIndexDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GlobalSecondaryIndexDescription> {
        public Builder indexName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder keySchema(Consumer<KeySchemaElement.Builder> ... var1);

        public Builder projection(Projection var1);

        default public Builder projection(Consumer<Projection.Builder> projection) {
            return this.projection((Projection)((Projection.Builder)Projection.builder().applyMutation(projection)).build());
        }

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder backfilling(Boolean var1);

        public Builder provisionedThroughput(ProvisionedThroughputDescription var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughputDescription.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughputDescription)((ProvisionedThroughputDescription.Builder)ProvisionedThroughputDescription.builder().applyMutation(provisionedThroughput)).build());
        }

        public Builder indexSizeBytes(Long var1);

        public Builder itemCount(Long var1);

        public Builder indexArn(String var1);
    }
}

