/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ShardMarshaller {
    private static final MarshallingInfo<String> SHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShardId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SEQUENCENUMBERRANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SequenceNumberRange").isBinary(false).build();
    private static final MarshallingInfo<String> PARENTSHARDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentShardId").isBinary(false).build();
    private static final ShardMarshaller INSTANCE = new ShardMarshaller();

    private ShardMarshaller() {
    }

    public static ShardMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Shard shard, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)shard, (String)"shard");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)shard.shardId(), SHARDID_BINDING);
            protocolMarshaller.marshall((Object)shard.sequenceNumberRange(), SEQUENCENUMBERRANGE_BINDING);
            protocolMarshaller.marshall((Object)shard.parentShardId(), PARENTSHARDID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

