/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.BackupDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BackupDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> BACKUPDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SOURCETABLEDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceTableDetails").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SOURCETABLEFEATUREDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceTableFeatureDetails").isBinary(false).build();
    private static final BackupDescriptionMarshaller INSTANCE = new BackupDescriptionMarshaller();

    private BackupDescriptionMarshaller() {
    }

    public static BackupDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BackupDescription backupDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)backupDescription, (String)"backupDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)backupDescription.backupDetails(), BACKUPDETAILS_BINDING);
            protocolMarshaller.marshall((Object)backupDescription.sourceTableDetails(), SOURCETABLEDETAILS_BINDING);
            protocolMarshaller.marshall((Object)backupDescription.sourceTableFeatureDetails(), SOURCETABLEFEATUREDETAILS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

