/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.RestoreSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, RestoreSummary> {
    private final String sourceBackupArn;
    private final String sourceTableArn;
    private final Instant restoreDateTime;
    private final Boolean restoreInProgress;

    private RestoreSummary(BuilderImpl builder) {
        this.sourceBackupArn = builder.sourceBackupArn;
        this.sourceTableArn = builder.sourceTableArn;
        this.restoreDateTime = builder.restoreDateTime;
        this.restoreInProgress = builder.restoreInProgress;
    }

    public String sourceBackupArn() {
        return this.sourceBackupArn;
    }

    public String sourceTableArn() {
        return this.sourceTableArn;
    }

    public Instant restoreDateTime() {
        return this.restoreDateTime;
    }

    public Boolean restoreInProgress() {
        return this.restoreInProgress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreInProgress());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreSummary)) {
            return false;
        }
        RestoreSummary other = (RestoreSummary)obj;
        return Objects.equals(this.sourceBackupArn(), other.sourceBackupArn()) && Objects.equals(this.sourceTableArn(), other.sourceTableArn()) && Objects.equals(this.restoreDateTime(), other.restoreDateTime()) && Objects.equals(this.restoreInProgress(), other.restoreInProgress());
    }

    public String toString() {
        return ToString.builder((String)"RestoreSummary").add("SourceBackupArn", (Object)this.sourceBackupArn()).add("SourceTableArn", (Object)this.sourceTableArn()).add("RestoreDateTime", (Object)this.restoreDateTime()).add("RestoreInProgress", (Object)this.restoreInProgress()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceBackupArn": {
                return Optional.ofNullable(clazz.cast(this.sourceBackupArn()));
            }
            case "SourceTableArn": {
                return Optional.ofNullable(clazz.cast(this.sourceTableArn()));
            }
            case "RestoreDateTime": {
                return Optional.ofNullable(clazz.cast(this.restoreDateTime()));
            }
            case "RestoreInProgress": {
                return Optional.ofNullable(clazz.cast(this.restoreInProgress()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RestoreSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceBackupArn;
        private String sourceTableArn;
        private Instant restoreDateTime;
        private Boolean restoreInProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreSummary model) {
            this.sourceBackupArn(model.sourceBackupArn);
            this.sourceTableArn(model.sourceTableArn);
            this.restoreDateTime(model.restoreDateTime);
            this.restoreInProgress(model.restoreInProgress);
        }

        public final String getSourceBackupArn() {
            return this.sourceBackupArn;
        }

        @Override
        public final Builder sourceBackupArn(String sourceBackupArn) {
            this.sourceBackupArn = sourceBackupArn;
            return this;
        }

        public final void setSourceBackupArn(String sourceBackupArn) {
            this.sourceBackupArn = sourceBackupArn;
        }

        public final String getSourceTableArn() {
            return this.sourceTableArn;
        }

        @Override
        public final Builder sourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
            return this;
        }

        public final void setSourceTableArn(String sourceTableArn) {
            this.sourceTableArn = sourceTableArn;
        }

        public final Instant getRestoreDateTime() {
            return this.restoreDateTime;
        }

        @Override
        public final Builder restoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
            return this;
        }

        public final void setRestoreDateTime(Instant restoreDateTime) {
            this.restoreDateTime = restoreDateTime;
        }

        public final Boolean getRestoreInProgress() {
            return this.restoreInProgress;
        }

        @Override
        public final Builder restoreInProgress(Boolean restoreInProgress) {
            this.restoreInProgress = restoreInProgress;
            return this;
        }

        public final void setRestoreInProgress(Boolean restoreInProgress) {
            this.restoreInProgress = restoreInProgress;
        }

        public RestoreSummary build() {
            return new RestoreSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RestoreSummary> {
        public Builder sourceBackupArn(String var1);

        public Builder sourceTableArn(String var1);

        public Builder restoreDateTime(Instant var1);

        public Builder restoreInProgress(Boolean var1);
    }
}

