/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodbstreams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.Stream;
import software.amazon.awssdk.services.dynamodbstreams.DynamoDBStreamsClient;

public class ListStreamsIterable
implements SdkIterable<ListStreamsResponse> {
    private final DynamoDBStreamsClient client;
    private final ListStreamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamsIterable(DynamoDBStreamsClient client, ListStreamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamsResponseFetcher();
    }

    public Iterator<ListStreamsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Stream> streams() {
        Function<ListStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.streams() != null) {
                return response.streams().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListStreamsIterable resume(ListStreamsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListStreamsIterable(this.client, (ListStreamsRequest)((Object)this.firstRequest.toBuilder().exclusiveStartStreamArn(lastSuccessfulPage.lastEvaluatedStreamArn()).build()));
        }
        return new ListStreamsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListStreamsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListStreamsResponseFetcher
    implements SyncPageFetcher<ListStreamsResponse> {
        private ListStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamsResponse previousPage) {
            return previousPage.lastEvaluatedStreamArn() != null;
        }

        public ListStreamsResponse nextPage(ListStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamsIterable.this.client.listStreams(ListStreamsIterable.this.firstRequest);
            }
            return ListStreamsIterable.this.client.listStreams((ListStreamsRequest)((Object)ListStreamsIterable.this.firstRequest.toBuilder().exclusiveStartStreamArn(previousPage.lastEvaluatedStreamArn()).build()));
        }
    }
}

