/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodbstreams.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.Shard;
import software.amazon.awssdk.services.dynamodbstreams.DynamoDBStreamsAsyncClient;

public class DescribeStreamPublisher
implements SdkPublisher<DescribeStreamResponse> {
    private final DynamoDBStreamsAsyncClient client;
    private final DescribeStreamRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeStreamPublisher(DynamoDBStreamsAsyncClient client, DescribeStreamRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeStreamPublisher(DynamoDBStreamsAsyncClient client, DescribeStreamRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeStreamResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeStreamResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Shard> shards() {
        Function<DescribeStreamResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamDescription() != null && response.streamDescription().shards() != null) {
                return response.streamDescription().shards().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeStreamResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeStreamPublisher resume(DescribeStreamResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeStreamPublisher(this.client, (DescribeStreamRequest)((Object)this.firstRequest.toBuilder().exclusiveStartShardId(lastSuccessfulPage.streamDescription().lastEvaluatedShardId()).build()));
        }
        return new DescribeStreamPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeStreamResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeStreamResponseFetcher
    implements AsyncPageFetcher<DescribeStreamResponse> {
        private DescribeStreamResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStreamResponse previousPage) {
            return previousPage.streamDescription().lastEvaluatedShardId() != null;
        }

        public CompletableFuture<DescribeStreamResponse> nextPage(DescribeStreamResponse previousPage) {
            if (previousPage == null) {
                return DescribeStreamPublisher.this.client.describeStream(DescribeStreamPublisher.this.firstRequest);
            }
            return DescribeStreamPublisher.this.client.describeStream((DescribeStreamRequest)((Object)DescribeStreamPublisher.this.firstRequest.toBuilder().exclusiveStartShardId(previousPage.streamDescription().lastEvaluatedShardId()).build()));
        }
    }
}

