/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodbstreams;

import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBException;
import software.amazon.awssdk.services.dynamodb.model.ExpiredIteratorException;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TrimmedDataAccessException;
import software.amazon.awssdk.services.dynamodbstreams.DefaultDynamoDBStreamsClientBuilder;
import software.amazon.awssdk.services.dynamodbstreams.DynamoDBStreamsClientBuilder;
import software.amazon.awssdk.services.dynamodbstreams.paginators.DescribeStreamPaginator;
import software.amazon.awssdk.services.dynamodbstreams.paginators.ListStreamsPaginator;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface DynamoDBStreamsClient
extends SdkClient,
SdkAutoCloseable {
    public static final String SERVICE_NAME = "dynamodb";

    public static DynamoDBStreamsClient create() {
        return (DynamoDBStreamsClient)DynamoDBStreamsClient.builder().build();
    }

    public static DynamoDBStreamsClientBuilder builder() {
        return new DefaultDynamoDBStreamsClientBuilder();
    }

    default public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public DescribeStreamResponse describeStream(Consumer<DescribeStreamRequest.Builder> describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, DynamoDBException {
        return this.describeStream((DescribeStreamRequest)((Object)((DescribeStreamRequest.Builder)DescribeStreamRequest.builder().apply(describeStreamRequest)).build()));
    }

    default public DescribeStreamPaginator describeStreamIterable(DescribeStreamRequest describeStreamRequest) throws ResourceNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public GetRecordsResponse getRecords(GetRecordsRequest getRecordsRequest) throws ResourceNotFoundException, LimitExceededException, InternalServerErrorException, ExpiredIteratorException, TrimmedDataAccessException, SdkServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public GetRecordsResponse getRecords(Consumer<GetRecordsRequest.Builder> getRecordsRequest) throws ResourceNotFoundException, LimitExceededException, InternalServerErrorException, ExpiredIteratorException, TrimmedDataAccessException, SdkServiceException, SdkClientException, DynamoDBException {
        return this.getRecords((GetRecordsRequest)((Object)((GetRecordsRequest.Builder)GetRecordsRequest.builder().apply(getRecordsRequest)).build()));
    }

    default public GetShardIteratorResponse getShardIterator(GetShardIteratorRequest getShardIteratorRequest) throws ResourceNotFoundException, InternalServerErrorException, TrimmedDataAccessException, SdkServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public GetShardIteratorResponse getShardIterator(Consumer<GetShardIteratorRequest.Builder> getShardIteratorRequest) throws ResourceNotFoundException, InternalServerErrorException, TrimmedDataAccessException, SdkServiceException, SdkClientException, DynamoDBException {
        return this.getShardIterator((GetShardIteratorRequest)((Object)((GetShardIteratorRequest.Builder)GetShardIteratorRequest.builder().apply(getShardIteratorRequest)).build()));
    }

    default public ListStreamsResponse listStreams() throws ResourceNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, DynamoDBException {
        return this.listStreams((ListStreamsRequest)((Object)ListStreamsRequest.builder().build()));
    }

    default public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    default public ListStreamsResponse listStreams(Consumer<ListStreamsRequest.Builder> listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, DynamoDBException {
        return this.listStreams((ListStreamsRequest)((Object)((ListStreamsRequest.Builder)ListStreamsRequest.builder().apply(listStreamsRequest)).build()));
    }

    default public ListStreamsPaginator listStreamsIterable() throws ResourceNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, DynamoDBException {
        return this.listStreamsIterable((ListStreamsRequest)((Object)ListStreamsRequest.builder().build()));
    }

    default public ListStreamsPaginator listStreamsIterable(ListStreamsRequest listStreamsRequest) throws ResourceNotFoundException, InternalServerErrorException, SdkServiceException, SdkClientException, DynamoDBException {
        throw new UnsupportedOperationException();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"streams.dynamodb");
    }
}

