/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.paginators;

import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.dynamodb.DynamoDBClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public final class ScanPaginator
implements SdkIterable<ScanResponse> {
    private final DynamoDBClient client;
    private final ScanRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ScanPaginator(DynamoDBClient client, ScanRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ScanResponseFetcher();
    }

    public Iterator<ScanResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Map<String, AttributeValue>> items() {
        Function<ScanResponse, Iterator> getIterator = response -> response != null ? response.items().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ScanResponseFetcher
    implements NextPageFetcher<ScanResponse> {
        private ScanResponseFetcher() {
        }

        public boolean hasNextPage(ScanResponse previousPage) {
            return previousPage.lastEvaluatedKey() != null;
        }

        public ScanResponse nextPage(ScanResponse previousPage) {
            if (previousPage == null) {
                return ScanPaginator.this.client.scan(ScanPaginator.this.firstRequest);
            }
            return ScanPaginator.this.client.scan((ScanRequest)((Object)ScanPaginator.this.firstRequest.toBuilder().exclusiveStartKey(previousPage.lastEvaluatedKey()).build()));
        }
    }
}

