/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinitionsCopier;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaCopier;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescription;
import software.amazon.awssdk.services.dynamodb.model.LocalSecondaryIndexDescriptionListCopier;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;
import software.amazon.awssdk.services.dynamodb.transform.TableDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TableDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, TableDescription> {
    private final List<AttributeDefinition> attributeDefinitions;
    private final String tableName;
    private final List<KeySchemaElement> keySchema;
    private final String tableStatus;
    private final Instant creationDateTime;
    private final ProvisionedThroughputDescription provisionedThroughput;
    private final Long tableSizeBytes;
    private final Long itemCount;
    private final String tableArn;
    private final List<LocalSecondaryIndexDescription> localSecondaryIndexes;
    private final List<GlobalSecondaryIndexDescription> globalSecondaryIndexes;
    private final StreamSpecification streamSpecification;
    private final String latestStreamLabel;
    private final String latestStreamArn;

    private TableDescription(BuilderImpl builder) {
        this.attributeDefinitions = builder.attributeDefinitions;
        this.tableName = builder.tableName;
        this.keySchema = builder.keySchema;
        this.tableStatus = builder.tableStatus;
        this.creationDateTime = builder.creationDateTime;
        this.provisionedThroughput = builder.provisionedThroughput;
        this.tableSizeBytes = builder.tableSizeBytes;
        this.itemCount = builder.itemCount;
        this.tableArn = builder.tableArn;
        this.localSecondaryIndexes = builder.localSecondaryIndexes;
        this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
        this.streamSpecification = builder.streamSpecification;
        this.latestStreamLabel = builder.latestStreamLabel;
        this.latestStreamArn = builder.latestStreamArn;
    }

    public List<AttributeDefinition> attributeDefinitions() {
        return this.attributeDefinitions;
    }

    public String tableName() {
        return this.tableName;
    }

    public List<KeySchemaElement> keySchema() {
        return this.keySchema;
    }

    public TableStatus tableStatus() {
        return TableStatus.fromValue(this.tableStatus);
    }

    public String tableStatusString() {
        return this.tableStatus;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public ProvisionedThroughputDescription provisionedThroughput() {
        return this.provisionedThroughput;
    }

    public Long tableSizeBytes() {
        return this.tableSizeBytes;
    }

    public Long itemCount() {
        return this.itemCount;
    }

    public String tableArn() {
        return this.tableArn;
    }

    public List<LocalSecondaryIndexDescription> localSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public List<GlobalSecondaryIndexDescription> globalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public StreamSpecification streamSpecification() {
        return this.streamSpecification;
    }

    public String latestStreamLabel() {
        return this.latestStreamLabel;
    }

    public String latestStreamArn() {
        return this.latestStreamArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.keySchema());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableStatusString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.localSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalSecondaryIndexes());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestStreamLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestStreamArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableDescription)) {
            return false;
        }
        TableDescription other = (TableDescription)obj;
        return Objects.equals(this.attributeDefinitions(), other.attributeDefinitions()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.keySchema(), other.keySchema()) && Objects.equals(this.tableStatusString(), other.tableStatusString()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.provisionedThroughput(), other.provisionedThroughput()) && Objects.equals(this.tableSizeBytes(), other.tableSizeBytes()) && Objects.equals(this.itemCount(), other.itemCount()) && Objects.equals(this.tableArn(), other.tableArn()) && Objects.equals(this.localSecondaryIndexes(), other.localSecondaryIndexes()) && Objects.equals(this.globalSecondaryIndexes(), other.globalSecondaryIndexes()) && Objects.equals(this.streamSpecification(), other.streamSpecification()) && Objects.equals(this.latestStreamLabel(), other.latestStreamLabel()) && Objects.equals(this.latestStreamArn(), other.latestStreamArn());
    }

    public String toString() {
        return ToString.builder((String)"TableDescription").add("AttributeDefinitions", this.attributeDefinitions()).add("TableName", (Object)this.tableName()).add("KeySchema", this.keySchema()).add("TableStatus", (Object)this.tableStatusString()).add("CreationDateTime", (Object)this.creationDateTime()).add("ProvisionedThroughput", (Object)this.provisionedThroughput()).add("TableSizeBytes", (Object)this.tableSizeBytes()).add("ItemCount", (Object)this.itemCount()).add("TableArn", (Object)this.tableArn()).add("LocalSecondaryIndexes", this.localSecondaryIndexes()).add("GlobalSecondaryIndexes", this.globalSecondaryIndexes()).add("StreamSpecification", (Object)this.streamSpecification()).add("LatestStreamLabel", (Object)this.latestStreamLabel()).add("LatestStreamArn", (Object)this.latestStreamArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttributeDefinitions": {
                return Optional.of(clazz.cast(this.attributeDefinitions()));
            }
            case "TableName": {
                return Optional.of(clazz.cast(this.tableName()));
            }
            case "KeySchema": {
                return Optional.of(clazz.cast(this.keySchema()));
            }
            case "TableStatus": {
                return Optional.of(clazz.cast(this.tableStatusString()));
            }
            case "CreationDateTime": {
                return Optional.of(clazz.cast(this.creationDateTime()));
            }
            case "ProvisionedThroughput": {
                return Optional.of(clazz.cast(this.provisionedThroughput()));
            }
            case "TableSizeBytes": {
                return Optional.of(clazz.cast(this.tableSizeBytes()));
            }
            case "ItemCount": {
                return Optional.of(clazz.cast(this.itemCount()));
            }
            case "TableArn": {
                return Optional.of(clazz.cast(this.tableArn()));
            }
            case "LocalSecondaryIndexes": {
                return Optional.of(clazz.cast(this.localSecondaryIndexes()));
            }
            case "GlobalSecondaryIndexes": {
                return Optional.of(clazz.cast(this.globalSecondaryIndexes()));
            }
            case "StreamSpecification": {
                return Optional.of(clazz.cast(this.streamSpecification()));
            }
            case "LatestStreamLabel": {
                return Optional.of(clazz.cast(this.latestStreamLabel()));
            }
            case "LatestStreamArn": {
                return Optional.of(clazz.cast(this.latestStreamArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TableDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AttributeDefinition> attributeDefinitions;
        private String tableName;
        private List<KeySchemaElement> keySchema;
        private String tableStatus;
        private Instant creationDateTime;
        private ProvisionedThroughputDescription provisionedThroughput;
        private Long tableSizeBytes;
        private Long itemCount;
        private String tableArn;
        private List<LocalSecondaryIndexDescription> localSecondaryIndexes;
        private List<GlobalSecondaryIndexDescription> globalSecondaryIndexes;
        private StreamSpecification streamSpecification;
        private String latestStreamLabel;
        private String latestStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(TableDescription model) {
            this.attributeDefinitions(model.attributeDefinitions);
            this.tableName(model.tableName);
            this.keySchema(model.keySchema);
            this.tableStatus(model.tableStatus);
            this.creationDateTime(model.creationDateTime);
            this.provisionedThroughput(model.provisionedThroughput);
            this.tableSizeBytes(model.tableSizeBytes);
            this.itemCount(model.itemCount);
            this.tableArn(model.tableArn);
            this.localSecondaryIndexes(model.localSecondaryIndexes);
            this.globalSecondaryIndexes(model.globalSecondaryIndexes);
            this.streamSpecification(model.streamSpecification);
            this.latestStreamLabel(model.latestStreamLabel);
            this.latestStreamArn(model.latestStreamArn);
        }

        public final Collection<AttributeDefinition.Builder> getAttributeDefinitions() {
            return this.attributeDefinitions != null ? (Collection)this.attributeDefinitions.stream().map(AttributeDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copy(attributeDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeDefinitions(AttributeDefinition ... attributeDefinitions) {
            this.attributeDefinitions(Arrays.asList(attributeDefinitions));
            return this;
        }

        public final void setAttributeDefinitions(Collection<AttributeDefinition.BuilderImpl> attributeDefinitions) {
            this.attributeDefinitions = AttributeDefinitionsCopier.copyFromBuilder(attributeDefinitions);
        }

        public final String getTableName() {
            return this.tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public final Collection<KeySchemaElement.Builder> getKeySchema() {
            return this.keySchema != null ? (Collection)this.keySchema.stream().map(KeySchemaElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keySchema(Collection<KeySchemaElement> keySchema) {
            this.keySchema = KeySchemaCopier.copy(keySchema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keySchema(KeySchemaElement ... keySchema) {
            this.keySchema(Arrays.asList(keySchema));
            return this;
        }

        public final void setKeySchema(Collection<KeySchemaElement.BuilderImpl> keySchema) {
            this.keySchema = KeySchemaCopier.copyFromBuilder(keySchema);
        }

        public final String getTableStatus() {
            return this.tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        @Override
        public final Builder tableStatus(TableStatus tableStatus) {
            this.tableStatus(tableStatus.toString());
            return this;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final ProvisionedThroughputDescription.Builder getProvisionedThroughput() {
            return this.provisionedThroughput != null ? this.provisionedThroughput.toBuilder() : null;
        }

        @Override
        public final Builder provisionedThroughput(ProvisionedThroughputDescription provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput;
            return this;
        }

        public final void setProvisionedThroughput(ProvisionedThroughputDescription.BuilderImpl provisionedThroughput) {
            this.provisionedThroughput = provisionedThroughput != null ? provisionedThroughput.build() : null;
        }

        public final Long getTableSizeBytes() {
            return this.tableSizeBytes;
        }

        @Override
        public final Builder tableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
            return this;
        }

        public final void setTableSizeBytes(Long tableSizeBytes) {
            this.tableSizeBytes = tableSizeBytes;
        }

        public final Long getItemCount() {
            return this.itemCount;
        }

        @Override
        public final Builder itemCount(Long itemCount) {
            this.itemCount = itemCount;
            return this;
        }

        public final void setItemCount(Long itemCount) {
            this.itemCount = itemCount;
        }

        public final String getTableArn() {
            return this.tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        public final Collection<LocalSecondaryIndexDescription.Builder> getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes != null ? (Collection)this.localSecondaryIndexes.stream().map(LocalSecondaryIndexDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder localSecondaryIndexes(Collection<LocalSecondaryIndexDescription> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexDescriptionListCopier.copy(localSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localSecondaryIndexes(LocalSecondaryIndexDescription ... localSecondaryIndexes) {
            this.localSecondaryIndexes(Arrays.asList(localSecondaryIndexes));
            return this;
        }

        public final void setLocalSecondaryIndexes(Collection<LocalSecondaryIndexDescription.BuilderImpl> localSecondaryIndexes) {
            this.localSecondaryIndexes = LocalSecondaryIndexDescriptionListCopier.copyFromBuilder(localSecondaryIndexes);
        }

        public final Collection<GlobalSecondaryIndexDescription.Builder> getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes != null ? (Collection)this.globalSecondaryIndexes.stream().map(GlobalSecondaryIndexDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexDescriptionListCopier.copy(globalSecondaryIndexes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalSecondaryIndexes(GlobalSecondaryIndexDescription ... globalSecondaryIndexes) {
            this.globalSecondaryIndexes(Arrays.asList(globalSecondaryIndexes));
            return this;
        }

        public final void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription.BuilderImpl> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = GlobalSecondaryIndexDescriptionListCopier.copyFromBuilder(globalSecondaryIndexes);
        }

        public final StreamSpecification.Builder getStreamSpecification() {
            return this.streamSpecification != null ? this.streamSpecification.toBuilder() : null;
        }

        @Override
        public final Builder streamSpecification(StreamSpecification streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        public final void setStreamSpecification(StreamSpecification.BuilderImpl streamSpecification) {
            this.streamSpecification = streamSpecification != null ? streamSpecification.build() : null;
        }

        public final String getLatestStreamLabel() {
            return this.latestStreamLabel;
        }

        @Override
        public final Builder latestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
            return this;
        }

        public final void setLatestStreamLabel(String latestStreamLabel) {
            this.latestStreamLabel = latestStreamLabel;
        }

        public final String getLatestStreamArn() {
            return this.latestStreamArn;
        }

        @Override
        public final Builder latestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
            return this;
        }

        public final void setLatestStreamArn(String latestStreamArn) {
            this.latestStreamArn = latestStreamArn;
        }

        public TableDescription build() {
            return new TableDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TableDescription> {
        public Builder attributeDefinitions(Collection<AttributeDefinition> var1);

        public Builder attributeDefinitions(AttributeDefinition ... var1);

        public Builder tableName(String var1);

        public Builder keySchema(Collection<KeySchemaElement> var1);

        public Builder keySchema(KeySchemaElement ... var1);

        public Builder tableStatus(String var1);

        public Builder tableStatus(TableStatus var1);

        public Builder creationDateTime(Instant var1);

        public Builder provisionedThroughput(ProvisionedThroughputDescription var1);

        default public Builder provisionedThroughput(Consumer<ProvisionedThroughputDescription.Builder> provisionedThroughput) {
            return this.provisionedThroughput((ProvisionedThroughputDescription)((ProvisionedThroughputDescription.Builder)ProvisionedThroughputDescription.builder().apply(provisionedThroughput)).build());
        }

        public Builder tableSizeBytes(Long var1);

        public Builder itemCount(Long var1);

        public Builder tableArn(String var1);

        public Builder localSecondaryIndexes(Collection<LocalSecondaryIndexDescription> var1);

        public Builder localSecondaryIndexes(LocalSecondaryIndexDescription ... var1);

        public Builder globalSecondaryIndexes(Collection<GlobalSecondaryIndexDescription> var1);

        public Builder globalSecondaryIndexes(GlobalSecondaryIndexDescription ... var1);

        public Builder streamSpecification(StreamSpecification var1);

        default public Builder streamSpecification(Consumer<StreamSpecification.Builder> streamSpecification) {
            return this.streamSpecification((StreamSpecification)((StreamSpecification.Builder)StreamSpecification.builder().apply(streamSpecification)).build());
        }

        public Builder latestStreamLabel(String var1);

        public Builder latestStreamArn(String var1);
    }
}

