/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.Stream;
import software.amazon.awssdk.services.dynamodb.model.StreamListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStreamsResponse
extends DynamoDBStreamsResponse
implements ToCopyableBuilder<Builder, ListStreamsResponse> {
    private final List<Stream> streams;
    private final String lastEvaluatedStreamArn;

    private ListStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.streams = builder.streams;
        this.lastEvaluatedStreamArn = builder.lastEvaluatedStreamArn;
    }

    public List<Stream> streams() {
        return this.streams;
    }

    public String lastEvaluatedStreamArn() {
        return this.lastEvaluatedStreamArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streams());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastEvaluatedStreamArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamsResponse)) {
            return false;
        }
        ListStreamsResponse other = (ListStreamsResponse)((Object)obj);
        return Objects.equals(this.streams(), other.streams()) && Objects.equals(this.lastEvaluatedStreamArn(), other.lastEvaluatedStreamArn());
    }

    public String toString() {
        return ToString.builder((String)"ListStreamsResponse").add("Streams", this.streams()).add("LastEvaluatedStreamArn", (Object)this.lastEvaluatedStreamArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Streams": {
                return Optional.of(clazz.cast(this.streams()));
            }
            case "LastEvaluatedStreamArn": {
                return Optional.of(clazz.cast(this.lastEvaluatedStreamArn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDBStreamsResponse.BuilderImpl
    implements Builder {
        private List<Stream> streams;
        private String lastEvaluatedStreamArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamsResponse model) {
            this.streams(model.streams);
            this.lastEvaluatedStreamArn(model.lastEvaluatedStreamArn);
        }

        public final Collection<Stream.Builder> getStreams() {
            return this.streams != null ? (Collection)this.streams.stream().map(Stream::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder streams(Collection<Stream> streams) {
            this.streams = StreamListCopier.copy(streams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streams(Stream ... streams) {
            this.streams(Arrays.asList(streams));
            return this;
        }

        public final void setStreams(Collection<Stream.BuilderImpl> streams) {
            this.streams = StreamListCopier.copyFromBuilder(streams);
        }

        public final String getLastEvaluatedStreamArn() {
            return this.lastEvaluatedStreamArn;
        }

        @Override
        public final Builder lastEvaluatedStreamArn(String lastEvaluatedStreamArn) {
            this.lastEvaluatedStreamArn = lastEvaluatedStreamArn;
            return this;
        }

        public final void setLastEvaluatedStreamArn(String lastEvaluatedStreamArn) {
            this.lastEvaluatedStreamArn = lastEvaluatedStreamArn;
        }

        @Override
        public ListStreamsResponse build() {
            return new ListStreamsResponse(this);
        }
    }

    public static interface Builder
    extends DynamoDBStreamsResponse.Builder,
    CopyableBuilder<Builder, ListStreamsResponse> {
        public Builder streams(Collection<Stream> var1);

        public Builder streams(Stream ... var1);

        public Builder lastEvaluatedStreamArn(String var1);
    }
}

