/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.AttributeNameListCopier;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ExpressionAttributeNameMapCopier;
import software.amazon.awssdk.services.dynamodb.model.KeyListCopier;
import software.amazon.awssdk.services.dynamodb.transform.KeysAndAttributesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KeysAndAttributes
implements StructuredPojo,
ToCopyableBuilder<Builder, KeysAndAttributes> {
    private final List<Map<String, AttributeValue>> keys;
    private final List<String> attributesToGet;
    private final Boolean consistentRead;
    private final String projectionExpression;
    private final Map<String, String> expressionAttributeNames;

    private KeysAndAttributes(BuilderImpl builder) {
        this.keys = builder.keys;
        this.attributesToGet = builder.attributesToGet;
        this.consistentRead = builder.consistentRead;
        this.projectionExpression = builder.projectionExpression;
        this.expressionAttributeNames = builder.expressionAttributeNames;
    }

    public List<Map<String, AttributeValue>> keys() {
        return this.keys;
    }

    public List<String> attributesToGet() {
        return this.attributesToGet;
    }

    public Boolean consistentRead() {
        return this.consistentRead;
    }

    public String projectionExpression() {
        return this.projectionExpression;
    }

    public Map<String, String> expressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keys());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributesToGet());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistentRead());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectionExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionAttributeNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeysAndAttributes)) {
            return false;
        }
        KeysAndAttributes other = (KeysAndAttributes)obj;
        return Objects.equals(this.keys(), other.keys()) && Objects.equals(this.attributesToGet(), other.attributesToGet()) && Objects.equals(this.consistentRead(), other.consistentRead()) && Objects.equals(this.projectionExpression(), other.projectionExpression()) && Objects.equals(this.expressionAttributeNames(), other.expressionAttributeNames());
    }

    public String toString() {
        return ToString.builder((String)"KeysAndAttributes").add("Keys", this.keys()).add("AttributesToGet", this.attributesToGet()).add("ConsistentRead", (Object)this.consistentRead()).add("ProjectionExpression", (Object)this.projectionExpression()).add("ExpressionAttributeNames", this.expressionAttributeNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Keys": {
                return Optional.of(clazz.cast(this.keys()));
            }
            case "AttributesToGet": {
                return Optional.of(clazz.cast(this.attributesToGet()));
            }
            case "ConsistentRead": {
                return Optional.of(clazz.cast(this.consistentRead()));
            }
            case "ProjectionExpression": {
                return Optional.of(clazz.cast(this.projectionExpression()));
            }
            case "ExpressionAttributeNames": {
                return Optional.of(clazz.cast(this.expressionAttributeNames()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeysAndAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Map<String, AttributeValue>> keys;
        private List<String> attributesToGet;
        private Boolean consistentRead;
        private String projectionExpression;
        private Map<String, String> expressionAttributeNames;

        private BuilderImpl() {
        }

        private BuilderImpl(KeysAndAttributes model) {
            this.keys(model.keys);
            this.attributesToGet(model.attributesToGet);
            this.consistentRead(model.consistentRead);
            this.projectionExpression(model.projectionExpression);
            this.expressionAttributeNames(model.expressionAttributeNames);
        }

        public final Collection<Map<String, AttributeValue>> getKeys() {
            return this.keys;
        }

        @Override
        public final Builder keys(Collection<Map<String, AttributeValue>> keys) {
            this.keys = KeyListCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(Map<String, AttributeValue> ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final void setKeys(Collection<Map<String, AttributeValue>> keys) {
            this.keys = KeyListCopier.copy(keys);
        }

        public final Collection<String> getAttributesToGet() {
            return this.attributesToGet;
        }

        @Override
        public final Builder attributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToGet(String ... attributesToGet) {
            this.attributesToGet(Arrays.asList(attributesToGet));
            return this;
        }

        public final void setAttributesToGet(Collection<String> attributesToGet) {
            this.attributesToGet = AttributeNameListCopier.copy(attributesToGet);
        }

        public final Boolean getConsistentRead() {
            return this.consistentRead;
        }

        @Override
        public final Builder consistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
            return this;
        }

        public final void setConsistentRead(Boolean consistentRead) {
            this.consistentRead = consistentRead;
        }

        public final String getProjectionExpression() {
            return this.projectionExpression;
        }

        @Override
        public final Builder projectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
            return this;
        }

        public final void setProjectionExpression(String projectionExpression) {
            this.projectionExpression = projectionExpression;
        }

        public final Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }

        @Override
        public final Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
            return this;
        }

        public final void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = ExpressionAttributeNameMapCopier.copy(expressionAttributeNames);
        }

        public KeysAndAttributes build() {
            return new KeysAndAttributes(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KeysAndAttributes> {
        public Builder keys(Collection<Map<String, AttributeValue>> var1);

        public Builder keys(Map<String, AttributeValue> ... var1);

        public Builder attributesToGet(Collection<String> var1);

        public Builder attributesToGet(String ... var1);

        public Builder consistentRead(Boolean var1);

        public Builder projectionExpression(String var1);

        public Builder expressionAttributeNames(Map<String, String> var1);
    }
}

