/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveSpecification;

@SdkInternalApi
public class TimeToLiveSpecificationMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<String> ATTRIBUTENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeName").build();
    private static final TimeToLiveSpecificationMarshaller INSTANCE = new TimeToLiveSpecificationMarshaller();

    public static TimeToLiveSpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TimeToLiveSpecification timeToLiveSpecification, ProtocolMarshaller protocolMarshaller) {
        if (timeToLiveSpecification == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)timeToLiveSpecification.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall((Object)timeToLiveSpecification.attributeName(), ATTRIBUTENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

