/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.builder.SdkBuilder;

@ReviewBeforeRelease(value="May want to do this a different way")
public final class Item
extends HashMap<String, AttributeValue> {
    private Item(Builder builder) {
        this.putAll(builder.item);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements SdkBuilder<Builder, Item> {
        private final Map<String, AttributeValue> item = new HashMap<String, AttributeValue>();

        private Builder() {
        }

        public Item build() {
            return new Item(this);
        }

        public Builder attribute(String key, String stringValue) {
            this.item.put(key, (AttributeValue)AttributeValue.builder().s(stringValue).build());
            return this;
        }

        public Builder attribute(String key, Boolean booleanValue) {
            this.item.put(key, (AttributeValue)AttributeValue.builder().bool(booleanValue).build());
            return this;
        }

        public Builder attribute(String key, Number numericValue) {
            this.item.put(key, (AttributeValue)AttributeValue.builder().n(String.valueOf(numericValue)).build());
            return this;
        }

        public Builder attribute(String key, byte[] binaryValue) {
            return this.attribute(key, ByteBuffer.wrap(binaryValue));
        }

        public Builder attribute(String key, ByteBuffer binaryValue) {
            this.item.put(key, (AttributeValue)AttributeValue.builder().b(binaryValue).build());
            return this;
        }

        public Builder attribute(String key, List<?> values) {
            this.item.put(key, Builder.fromObject(values));
            return this;
        }

        public Builder attribute(String key, Map<String, ?> values) {
            this.item.put(key, Builder.fromObject(values));
            return this;
        }

        public Builder strings(String key, String ... stringValues) {
            return this.strings(key, Arrays.asList(stringValues));
        }

        public Builder strings(String key, Collection<String> stringValues) {
            this.item.put(key, (AttributeValue)AttributeValue.builder().ss(stringValues).build());
            return this;
        }

        public Builder numbers(String key, Number ... numberValues) {
            return this.numbers(key, Arrays.asList(numberValues));
        }

        public Builder numbers(String key, Collection<? extends Number> numberValues) {
            this.item.put(key, (AttributeValue)AttributeValue.builder().ns(numberValues.stream().map(String::valueOf).collect(Collectors.toList())).build());
            return this;
        }

        public Builder byteArrays(String key, byte[] ... byteArrays) {
            return this.byteArrays(key, Arrays.asList(byteArrays));
        }

        public Builder byteArrays(String key, Collection<byte[]> byteArrays) {
            return this.byteBuffers(key, byteArrays.stream().map(ByteBuffer::wrap).collect(Collectors.toList()));
        }

        public Builder byteBuffers(String key, ByteBuffer ... binaryValues) {
            return this.byteBuffers(key, Arrays.asList(binaryValues));
        }

        public Builder byteBuffers(String key, Collection<? extends ByteBuffer> binaryValues) {
            this.item.put(key, (AttributeValue)AttributeValue.builder().bs(binaryValues.stream().collect(Collectors.toList())).build());
            return this;
        }

        private static AttributeValue fromObject(Object object) {
            if (object instanceof AttributeValue) {
                return (AttributeValue)object;
            }
            if (object instanceof String) {
                return (AttributeValue)AttributeValue.builder().s((String)object).build();
            }
            if (object instanceof Number) {
                return (AttributeValue)AttributeValue.builder().n(String.valueOf((Number)object)).build();
            }
            if (object instanceof byte[]) {
                return (AttributeValue)AttributeValue.builder().b(ByteBuffer.wrap((byte[])object)).build();
            }
            if (object instanceof ByteBuffer) {
                return (AttributeValue)AttributeValue.builder().b((ByteBuffer)object).build();
            }
            if (object instanceof Boolean) {
                return (AttributeValue)AttributeValue.builder().bool((Boolean)object).build();
            }
            if (object instanceof List) {
                List<AttributeValue> attributeValues = ((List)object).stream().map(Builder::fromObject).collect(Collectors.toList());
                return (AttributeValue)AttributeValue.builder().l(attributeValues).build();
            }
            if (object instanceof Map) {
                Map attributeValues = (Map)((Map)object).entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry(e.getKey(), Builder.fromObject(e.getValue()))).collect(CollectionUtils.toMap());
                return (AttributeValue)AttributeValue.builder().m(attributeValues).build();
            }
            throw new IllegalArgumentException("Unsupported type: " + object.getClass());
        }
    }
}

