/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.model.DynamoDBStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.dynamodb.model.RecordListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetRecordsResponse
extends DynamoDBStreamsResponse
implements ToCopyableBuilder<Builder, GetRecordsResponse> {
    private final List<Record> records;
    private final String nextShardIterator;

    private GetRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.nextShardIterator = builder.nextShardIterator;
    }

    public List<Record> records() {
        return this.records;
    }

    public String nextShardIterator() {
        return this.nextShardIterator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.records());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextShardIterator());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecordsResponse)) {
            return false;
        }
        GetRecordsResponse other = (GetRecordsResponse)((Object)obj);
        return Objects.equals(this.records(), other.records()) && Objects.equals(this.nextShardIterator(), other.nextShardIterator());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.records() != null) {
            sb.append("Records: ").append(this.records()).append(",");
        }
        if (this.nextShardIterator() != null) {
            sb.append("NextShardIterator: ").append(this.nextShardIterator()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Records": {
                return Optional.of(clazz.cast(this.records()));
            }
            case "NextShardIterator": {
                return Optional.of(clazz.cast(this.nextShardIterator()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DynamoDBStreamsResponse.BuilderImpl
    implements Builder {
        private List<Record> records;
        private String nextShardIterator;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecordsResponse model) {
            this.records(model.records);
            this.nextShardIterator(model.nextShardIterator);
        }

        public final Collection<Record.Builder> getRecords() {
            return this.records != null ? (Collection)this.records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordListCopier.copyFromBuilder(records);
        }

        public final String getNextShardIterator() {
            return this.nextShardIterator;
        }

        @Override
        public final Builder nextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
            return this;
        }

        public final void setNextShardIterator(String nextShardIterator) {
            this.nextShardIterator = nextShardIterator;
        }

        @Override
        public GetRecordsResponse build() {
            return new GetRecordsResponse(this);
        }
    }

    public static interface Builder
    extends DynamoDBStreamsResponse.Builder,
    CopyableBuilder<Builder, GetRecordsResponse> {
        public Builder records(Collection<Record> var1);

        public Builder records(Record ... var1);

        public Builder nextShardIterator(String var1);
    }
}

