/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodbstreams.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse;
import software.amazon.awssdk.services.dynamodb.model.Stream;
import software.amazon.awssdk.services.dynamodbstreams.DynamoDBStreamsClient;

public final class ListStreamsPaginator
implements SdkIterable<ListStreamsResponse> {
    private final DynamoDBStreamsClient client;
    private final ListStreamsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListStreamsPaginator(DynamoDBStreamsClient client, ListStreamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamsResponseFetcher();
    }

    public Iterator<ListStreamsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Stream> streams() {
        Function<ListStreamsResponse, Iterator> getIterator = response -> response != null ? response.streams().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListStreamsResponseFetcher
    implements NextPageFetcher<ListStreamsResponse> {
        private ListStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamsResponse previousPage) {
            return previousPage.lastEvaluatedStreamArn() != null;
        }

        public ListStreamsResponse nextPage(ListStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamsPaginator.this.client.listStreams(ListStreamsPaginator.this.firstRequest);
            }
            return ListStreamsPaginator.this.client.listStreams((ListStreamsRequest)((Object)ListStreamsPaginator.this.firstRequest.toBuilder().exclusiveStartStreamArn(previousPage.lastEvaluatedStreamArn()).build()));
        }
    }
}

