/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;

@SdkInternalApi
public class WriteRequestMarshaller {
    private static final MarshallingInfo<StructuredPojo> PUTREQUEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PutRequest").build();
    private static final MarshallingInfo<StructuredPojo> DELETEREQUEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeleteRequest").build();
    private static final WriteRequestMarshaller INSTANCE = new WriteRequestMarshaller();

    public static WriteRequestMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(WriteRequest writeRequest, ProtocolMarshaller protocolMarshaller) {
        if (writeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)writeRequest.putRequest(), PUTREQUEST_BINDING);
            protocolMarshaller.marshall((Object)writeRequest.deleteRequest(), DELETEREQUEST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

