/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.GlobalSecondaryIndexDescription;

@SdkInternalApi
public class GlobalSecondaryIndexDescriptionMarshaller {
    private static final MarshallingInfo<String> INDEXNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexName").build();
    private static final MarshallingInfo<List> KEYSCHEMA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeySchema").build();
    private static final MarshallingInfo<StructuredPojo> PROJECTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Projection").build();
    private static final MarshallingInfo<String> INDEXSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexStatus").build();
    private static final MarshallingInfo<Boolean> BACKFILLING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Backfilling").build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONEDTHROUGHPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedThroughput").build();
    private static final MarshallingInfo<Long> INDEXSIZEBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexSizeBytes").build();
    private static final MarshallingInfo<Long> ITEMCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemCount").build();
    private static final MarshallingInfo<String> INDEXARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IndexArn").build();
    private static final GlobalSecondaryIndexDescriptionMarshaller INSTANCE = new GlobalSecondaryIndexDescriptionMarshaller();

    public static GlobalSecondaryIndexDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GlobalSecondaryIndexDescription globalSecondaryIndexDescription, ProtocolMarshaller protocolMarshaller) {
        if (globalSecondaryIndexDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.indexName(), INDEXNAME_BINDING);
            protocolMarshaller.marshall(globalSecondaryIndexDescription.keySchema(), KEYSCHEMA_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.projection(), PROJECTION_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.indexStatusString(), INDEXSTATUS_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.backfilling(), BACKFILLING_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.provisionedThroughput(), PROVISIONEDTHROUGHPUT_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.indexSizeBytes(), INDEXSIZEBYTES_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.itemCount(), ITEMCOUNT_BINDING);
            protocolMarshaller.marshall((Object)globalSecondaryIndexDescription.indexArn(), INDEXARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

