/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.Tag;
import software.amazon.awssdk.services.dynamodb.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TagResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, TagResourceRequest> {
    private final String resourceArn;
    private final List<Tag> tags;

    private TagResourceRequest(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.tags = builder.tags;
    }

    public String resourceArn() {
        return this.resourceArn;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagResourceRequest)) {
            return false;
        }
        TagResourceRequest other = (TagResourceRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceArn() != null) {
            sb.append("ResourceArn: ").append(this.resourceArn()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.of(clazz.cast(this.resourceArn()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceArn;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(TagResourceRequest model) {
            this.resourceArn(model.resourceArn);
            this.tags(model.tags);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public TagResourceRequest build() {
            return new TagResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TagResourceRequest> {
        public Builder resourceArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

