/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLimitsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLimitsResponse> {
    private final Long accountMaxReadCapacityUnits;
    private final Long accountMaxWriteCapacityUnits;
    private final Long tableMaxReadCapacityUnits;
    private final Long tableMaxWriteCapacityUnits;

    private DescribeLimitsResponse(BuilderImpl builder) {
        this.accountMaxReadCapacityUnits = builder.accountMaxReadCapacityUnits;
        this.accountMaxWriteCapacityUnits = builder.accountMaxWriteCapacityUnits;
        this.tableMaxReadCapacityUnits = builder.tableMaxReadCapacityUnits;
        this.tableMaxWriteCapacityUnits = builder.tableMaxWriteCapacityUnits;
    }

    public Long accountMaxReadCapacityUnits() {
        return this.accountMaxReadCapacityUnits;
    }

    public Long accountMaxWriteCapacityUnits() {
        return this.accountMaxWriteCapacityUnits;
    }

    public Long tableMaxReadCapacityUnits() {
        return this.tableMaxReadCapacityUnits;
    }

    public Long tableMaxWriteCapacityUnits() {
        return this.tableMaxWriteCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountMaxReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountMaxWriteCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMaxReadCapacityUnits());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableMaxWriteCapacityUnits());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLimitsResponse)) {
            return false;
        }
        DescribeLimitsResponse other = (DescribeLimitsResponse)((Object)obj);
        return Objects.equals(this.accountMaxReadCapacityUnits(), other.accountMaxReadCapacityUnits()) && Objects.equals(this.accountMaxWriteCapacityUnits(), other.accountMaxWriteCapacityUnits()) && Objects.equals(this.tableMaxReadCapacityUnits(), other.tableMaxReadCapacityUnits()) && Objects.equals(this.tableMaxWriteCapacityUnits(), other.tableMaxWriteCapacityUnits());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountMaxReadCapacityUnits() != null) {
            sb.append("AccountMaxReadCapacityUnits: ").append(this.accountMaxReadCapacityUnits()).append(",");
        }
        if (this.accountMaxWriteCapacityUnits() != null) {
            sb.append("AccountMaxWriteCapacityUnits: ").append(this.accountMaxWriteCapacityUnits()).append(",");
        }
        if (this.tableMaxReadCapacityUnits() != null) {
            sb.append("TableMaxReadCapacityUnits: ").append(this.tableMaxReadCapacityUnits()).append(",");
        }
        if (this.tableMaxWriteCapacityUnits() != null) {
            sb.append("TableMaxWriteCapacityUnits: ").append(this.tableMaxWriteCapacityUnits()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountMaxReadCapacityUnits": {
                return Optional.of(clazz.cast(this.accountMaxReadCapacityUnits()));
            }
            case "AccountMaxWriteCapacityUnits": {
                return Optional.of(clazz.cast(this.accountMaxWriteCapacityUnits()));
            }
            case "TableMaxReadCapacityUnits": {
                return Optional.of(clazz.cast(this.tableMaxReadCapacityUnits()));
            }
            case "TableMaxWriteCapacityUnits": {
                return Optional.of(clazz.cast(this.tableMaxWriteCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Long accountMaxReadCapacityUnits;
        private Long accountMaxWriteCapacityUnits;
        private Long tableMaxReadCapacityUnits;
        private Long tableMaxWriteCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLimitsResponse model) {
            this.accountMaxReadCapacityUnits(model.accountMaxReadCapacityUnits);
            this.accountMaxWriteCapacityUnits(model.accountMaxWriteCapacityUnits);
            this.tableMaxReadCapacityUnits(model.tableMaxReadCapacityUnits);
            this.tableMaxWriteCapacityUnits(model.tableMaxWriteCapacityUnits);
        }

        public final Long getAccountMaxReadCapacityUnits() {
            return this.accountMaxReadCapacityUnits;
        }

        @Override
        public final Builder accountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits) {
            this.accountMaxReadCapacityUnits = accountMaxReadCapacityUnits;
            return this;
        }

        public final void setAccountMaxReadCapacityUnits(Long accountMaxReadCapacityUnits) {
            this.accountMaxReadCapacityUnits = accountMaxReadCapacityUnits;
        }

        public final Long getAccountMaxWriteCapacityUnits() {
            return this.accountMaxWriteCapacityUnits;
        }

        @Override
        public final Builder accountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits) {
            this.accountMaxWriteCapacityUnits = accountMaxWriteCapacityUnits;
            return this;
        }

        public final void setAccountMaxWriteCapacityUnits(Long accountMaxWriteCapacityUnits) {
            this.accountMaxWriteCapacityUnits = accountMaxWriteCapacityUnits;
        }

        public final Long getTableMaxReadCapacityUnits() {
            return this.tableMaxReadCapacityUnits;
        }

        @Override
        public final Builder tableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits) {
            this.tableMaxReadCapacityUnits = tableMaxReadCapacityUnits;
            return this;
        }

        public final void setTableMaxReadCapacityUnits(Long tableMaxReadCapacityUnits) {
            this.tableMaxReadCapacityUnits = tableMaxReadCapacityUnits;
        }

        public final Long getTableMaxWriteCapacityUnits() {
            return this.tableMaxWriteCapacityUnits;
        }

        @Override
        public final Builder tableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits) {
            this.tableMaxWriteCapacityUnits = tableMaxWriteCapacityUnits;
            return this;
        }

        public final void setTableMaxWriteCapacityUnits(Long tableMaxWriteCapacityUnits) {
            this.tableMaxWriteCapacityUnits = tableMaxWriteCapacityUnits;
        }

        public DescribeLimitsResponse build() {
            return new DescribeLimitsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLimitsResponse> {
        public Builder accountMaxReadCapacityUnits(Long var1);

        public Builder accountMaxWriteCapacityUnits(Long var1);

        public Builder tableMaxReadCapacityUnits(Long var1);

        public Builder tableMaxWriteCapacityUnits(Long var1);
    }
}

