/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacityMultipleCopier;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetricsPerTableCopier;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchWriteItemResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchWriteItemResponse> {
    private final Map<String, List<WriteRequest>> unprocessedItems;
    private final Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;
    private final List<ConsumedCapacity> consumedCapacity;

    private BatchWriteItemResponse(BuilderImpl builder) {
        this.unprocessedItems = builder.unprocessedItems;
        this.itemCollectionMetrics = builder.itemCollectionMetrics;
        this.consumedCapacity = builder.consumedCapacity;
    }

    public Map<String, List<WriteRequest>> unprocessedItems() {
        return this.unprocessedItems;
    }

    public Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics() {
        return this.itemCollectionMetrics;
    }

    public List<ConsumedCapacity> consumedCapacity() {
        return this.consumedCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.unprocessedItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemCollectionMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemResponse)) {
            return false;
        }
        BatchWriteItemResponse other = (BatchWriteItemResponse)((Object)obj);
        return Objects.equals(this.unprocessedItems(), other.unprocessedItems()) && Objects.equals(this.itemCollectionMetrics(), other.itemCollectionMetrics()) && Objects.equals(this.consumedCapacity(), other.consumedCapacity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.unprocessedItems() != null) {
            sb.append("UnprocessedItems: ").append(this.unprocessedItems()).append(",");
        }
        if (this.itemCollectionMetrics() != null) {
            sb.append("ItemCollectionMetrics: ").append(this.itemCollectionMetrics()).append(",");
        }
        if (this.consumedCapacity() != null) {
            sb.append("ConsumedCapacity: ").append(this.consumedCapacity()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnprocessedItems": {
                return Optional.of(clazz.cast(this.unprocessedItems()));
            }
            case "ItemCollectionMetrics": {
                return Optional.of(clazz.cast(this.itemCollectionMetrics()));
            }
            case "ConsumedCapacity": {
                return Optional.of(clazz.cast(this.consumedCapacity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<WriteRequest>> unprocessedItems;
        private Map<String, List<ItemCollectionMetrics>> itemCollectionMetrics;
        private List<ConsumedCapacity> consumedCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemResponse model) {
            this.unprocessedItems(model.unprocessedItems);
            this.itemCollectionMetrics(model.itemCollectionMetrics);
            this.consumedCapacity(model.consumedCapacity);
        }

        public final Map<String, ? extends Collection<WriteRequest>> getUnprocessedItems() {
            return this.unprocessedItems;
        }

        @Override
        public final Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
            return this;
        }

        public final void setUnprocessedItems(Map<String, ? extends Collection<WriteRequest>> unprocessedItems) {
            this.unprocessedItems = BatchWriteItemRequestMapCopier.copy(unprocessedItems);
        }

        public final Map<String, ? extends Collection<ItemCollectionMetrics>> getItemCollectionMetrics() {
            return this.itemCollectionMetrics;
        }

        @Override
        public final Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
            return this;
        }

        public final void setItemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> itemCollectionMetrics) {
            this.itemCollectionMetrics = ItemCollectionMetricsPerTableCopier.copy(itemCollectionMetrics);
        }

        public final Collection<ConsumedCapacity.Builder> getConsumedCapacity() {
            return this.consumedCapacity != null ? (Collection)this.consumedCapacity.stream().map(ConsumedCapacity::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder consumedCapacity(Collection<ConsumedCapacity> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copy(consumedCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumedCapacity(ConsumedCapacity ... consumedCapacity) {
            this.consumedCapacity(Arrays.asList(consumedCapacity));
            return this;
        }

        public final void setConsumedCapacity(Collection<ConsumedCapacity.BuilderImpl> consumedCapacity) {
            this.consumedCapacity = ConsumedCapacityMultipleCopier.copyFromBuilder(consumedCapacity);
        }

        public BatchWriteItemResponse build() {
            return new BatchWriteItemResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchWriteItemResponse> {
        public Builder unprocessedItems(Map<String, ? extends Collection<WriteRequest>> var1);

        public Builder itemCollectionMetrics(Map<String, ? extends Collection<ItemCollectionMetrics>> var1);

        public Builder consumedCapacity(Collection<ConsumedCapacity> var1);

        public Builder consumedCapacity(ConsumedCapacity ... var1);
    }
}

