/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.dynamodb.model.BatchWriteItemRequestMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchWriteItemRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchWriteItemRequest> {
    private final Map<String, List<WriteRequest>> requestItems;
    private final String returnConsumedCapacity;
    private final String returnItemCollectionMetrics;

    private BatchWriteItemRequest(BuilderImpl builder) {
        this.requestItems = builder.requestItems;
        this.returnConsumedCapacity = builder.returnConsumedCapacity;
        this.returnItemCollectionMetrics = builder.returnItemCollectionMetrics;
    }

    public Map<String, List<WriteRequest>> requestItems() {
        return this.requestItems;
    }

    public ReturnConsumedCapacity returnConsumedCapacity() {
        return ReturnConsumedCapacity.fromValue(this.returnConsumedCapacity);
    }

    public String returnConsumedCapacityString() {
        return this.returnConsumedCapacity;
    }

    public ReturnItemCollectionMetrics returnItemCollectionMetrics() {
        return ReturnItemCollectionMetrics.fromValue(this.returnItemCollectionMetrics);
    }

    public String returnItemCollectionMetricsString() {
        return this.returnItemCollectionMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnConsumedCapacityString());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnItemCollectionMetricsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteItemRequest)) {
            return false;
        }
        BatchWriteItemRequest other = (BatchWriteItemRequest)((Object)obj);
        return Objects.equals(this.requestItems(), other.requestItems()) && Objects.equals(this.returnConsumedCapacityString(), other.returnConsumedCapacityString()) && Objects.equals(this.returnItemCollectionMetricsString(), other.returnItemCollectionMetricsString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.requestItems() != null) {
            sb.append("RequestItems: ").append(this.requestItems()).append(",");
        }
        if (this.returnConsumedCapacityString() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.returnConsumedCapacityString()).append(",");
        }
        if (this.returnItemCollectionMetricsString() != null) {
            sb.append("ReturnItemCollectionMetrics: ").append(this.returnItemCollectionMetricsString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestItems": {
                return Optional.of(clazz.cast(this.requestItems()));
            }
            case "ReturnConsumedCapacity": {
                return Optional.of(clazz.cast(this.returnConsumedCapacityString()));
            }
            case "ReturnItemCollectionMetrics": {
                return Optional.of(clazz.cast(this.returnItemCollectionMetricsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<WriteRequest>> requestItems;
        private String returnConsumedCapacity;
        private String returnItemCollectionMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteItemRequest model) {
            this.requestItems(model.requestItems);
            this.returnConsumedCapacity(model.returnConsumedCapacity);
            this.returnItemCollectionMetrics(model.returnItemCollectionMetrics);
        }

        public final Map<String, ? extends Collection<WriteRequest>> getRequestItems() {
            return this.requestItems;
        }

        @Override
        public final Builder requestItems(Map<String, ? extends Collection<WriteRequest>> requestItems) {
            this.requestItems = BatchWriteItemRequestMapCopier.copy(requestItems);
            return this;
        }

        public final void setRequestItems(Map<String, ? extends Collection<WriteRequest>> requestItems) {
            this.requestItems = BatchWriteItemRequestMapCopier.copy(requestItems);
        }

        public final String getReturnConsumedCapacity() {
            return this.returnConsumedCapacity;
        }

        @Override
        public final Builder returnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        @Override
        public final Builder returnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity(returnConsumedCapacity.toString());
            return this;
        }

        public final void setReturnConsumedCapacity(String returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
        }

        public final String getReturnItemCollectionMetrics() {
            return this.returnItemCollectionMetrics;
        }

        @Override
        public final Builder returnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        @Override
        public final Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics(returnItemCollectionMetrics.toString());
            return this;
        }

        public final void setReturnItemCollectionMetrics(String returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
        }

        public BatchWriteItemRequest build() {
            return new BatchWriteItemRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchWriteItemRequest> {
        public Builder requestItems(Map<String, ? extends Collection<WriteRequest>> var1);

        public Builder returnConsumedCapacity(String var1);

        public Builder returnConsumedCapacity(ReturnConsumedCapacity var1);

        public Builder returnItemCollectionMetrics(String var1);

        public Builder returnItemCollectionMetrics(ReturnItemCollectionMetrics var1);
    }
}

