/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.model.TimeToLiveStatus;
import software.amazon.awssdk.services.dynamodb.transform.TimeToLiveDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TimeToLiveDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, TimeToLiveDescription> {
    private final String timeToLiveStatus;
    private final String attributeName;

    private TimeToLiveDescription(BuilderImpl builder) {
        this.timeToLiveStatus = builder.timeToLiveStatus;
        this.attributeName = builder.attributeName;
    }

    public TimeToLiveStatus timeToLiveStatus() {
        return TimeToLiveStatus.fromValue(this.timeToLiveStatus);
    }

    public String timeToLiveStatusString() {
        return this.timeToLiveStatus;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.timeToLiveStatusString() == null ? 0 : this.timeToLiveStatusString().hashCode());
        hashCode = 31 * hashCode + (this.attributeName() == null ? 0 : this.attributeName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeToLiveDescription)) {
            return false;
        }
        TimeToLiveDescription other = (TimeToLiveDescription)obj;
        if (other.timeToLiveStatusString() == null ^ this.timeToLiveStatusString() == null) {
            return false;
        }
        if (other.timeToLiveStatusString() != null && !other.timeToLiveStatusString().equals(this.timeToLiveStatusString())) {
            return false;
        }
        if (other.attributeName() == null ^ this.attributeName() == null) {
            return false;
        }
        return other.attributeName() == null || other.attributeName().equals(this.attributeName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.timeToLiveStatusString() != null) {
            sb.append("TimeToLiveStatus: ").append(this.timeToLiveStatusString()).append(",");
        }
        if (this.attributeName() != null) {
            sb.append("AttributeName: ").append(this.attributeName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeToLiveStatus": {
                return Optional.of(clazz.cast(this.timeToLiveStatusString()));
            }
            case "AttributeName": {
                return Optional.of(clazz.cast(this.attributeName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeToLiveDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String timeToLiveStatus;
        private String attributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeToLiveDescription model) {
            this.timeToLiveStatus(model.timeToLiveStatus);
            this.attributeName(model.attributeName);
        }

        public final String getTimeToLiveStatus() {
            return this.timeToLiveStatus;
        }

        @Override
        public final Builder timeToLiveStatus(String timeToLiveStatus) {
            this.timeToLiveStatus = timeToLiveStatus;
            return this;
        }

        @Override
        public final Builder timeToLiveStatus(TimeToLiveStatus timeToLiveStatus) {
            this.timeToLiveStatus(timeToLiveStatus.toString());
            return this;
        }

        public final void setTimeToLiveStatus(String timeToLiveStatus) {
            this.timeToLiveStatus = timeToLiveStatus;
        }

        public final String getAttributeName() {
            return this.attributeName;
        }

        @Override
        public final Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            return this;
        }

        public final void setAttributeName(String attributeName) {
            this.attributeName = attributeName;
        }

        public TimeToLiveDescription build() {
            return new TimeToLiveDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimeToLiveDescription> {
        public Builder timeToLiveStatus(String var1);

        public Builder timeToLiveStatus(TimeToLiveStatus var1);

        public Builder attributeName(String var1);
    }
}

