/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.dynamodb.transform.ProvisionedThroughputDescriptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisionedThroughputDescription
implements StructuredPojo,
ToCopyableBuilder<Builder, ProvisionedThroughputDescription> {
    private final Instant lastIncreaseDateTime;
    private final Instant lastDecreaseDateTime;
    private final Long numberOfDecreasesToday;
    private final Long readCapacityUnits;
    private final Long writeCapacityUnits;

    private ProvisionedThroughputDescription(BuilderImpl builder) {
        this.lastIncreaseDateTime = builder.lastIncreaseDateTime;
        this.lastDecreaseDateTime = builder.lastDecreaseDateTime;
        this.numberOfDecreasesToday = builder.numberOfDecreasesToday;
        this.readCapacityUnits = builder.readCapacityUnits;
        this.writeCapacityUnits = builder.writeCapacityUnits;
    }

    public Instant lastIncreaseDateTime() {
        return this.lastIncreaseDateTime;
    }

    public Instant lastDecreaseDateTime() {
        return this.lastDecreaseDateTime;
    }

    public Long numberOfDecreasesToday() {
        return this.numberOfDecreasesToday;
    }

    public Long readCapacityUnits() {
        return this.readCapacityUnits;
    }

    public Long writeCapacityUnits() {
        return this.writeCapacityUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.lastIncreaseDateTime() == null ? 0 : this.lastIncreaseDateTime().hashCode());
        hashCode = 31 * hashCode + (this.lastDecreaseDateTime() == null ? 0 : this.lastDecreaseDateTime().hashCode());
        hashCode = 31 * hashCode + (this.numberOfDecreasesToday() == null ? 0 : this.numberOfDecreasesToday().hashCode());
        hashCode = 31 * hashCode + (this.readCapacityUnits() == null ? 0 : this.readCapacityUnits().hashCode());
        hashCode = 31 * hashCode + (this.writeCapacityUnits() == null ? 0 : this.writeCapacityUnits().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisionedThroughputDescription)) {
            return false;
        }
        ProvisionedThroughputDescription other = (ProvisionedThroughputDescription)obj;
        if (other.lastIncreaseDateTime() == null ^ this.lastIncreaseDateTime() == null) {
            return false;
        }
        if (other.lastIncreaseDateTime() != null && !other.lastIncreaseDateTime().equals(this.lastIncreaseDateTime())) {
            return false;
        }
        if (other.lastDecreaseDateTime() == null ^ this.lastDecreaseDateTime() == null) {
            return false;
        }
        if (other.lastDecreaseDateTime() != null && !other.lastDecreaseDateTime().equals(this.lastDecreaseDateTime())) {
            return false;
        }
        if (other.numberOfDecreasesToday() == null ^ this.numberOfDecreasesToday() == null) {
            return false;
        }
        if (other.numberOfDecreasesToday() != null && !other.numberOfDecreasesToday().equals(this.numberOfDecreasesToday())) {
            return false;
        }
        if (other.readCapacityUnits() == null ^ this.readCapacityUnits() == null) {
            return false;
        }
        if (other.readCapacityUnits() != null && !other.readCapacityUnits().equals(this.readCapacityUnits())) {
            return false;
        }
        if (other.writeCapacityUnits() == null ^ this.writeCapacityUnits() == null) {
            return false;
        }
        return other.writeCapacityUnits() == null || other.writeCapacityUnits().equals(this.writeCapacityUnits());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.lastIncreaseDateTime() != null) {
            sb.append("LastIncreaseDateTime: ").append(this.lastIncreaseDateTime()).append(",");
        }
        if (this.lastDecreaseDateTime() != null) {
            sb.append("LastDecreaseDateTime: ").append(this.lastDecreaseDateTime()).append(",");
        }
        if (this.numberOfDecreasesToday() != null) {
            sb.append("NumberOfDecreasesToday: ").append(this.numberOfDecreasesToday()).append(",");
        }
        if (this.readCapacityUnits() != null) {
            sb.append("ReadCapacityUnits: ").append(this.readCapacityUnits()).append(",");
        }
        if (this.writeCapacityUnits() != null) {
            sb.append("WriteCapacityUnits: ").append(this.writeCapacityUnits()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LastIncreaseDateTime": {
                return Optional.of(clazz.cast(this.lastIncreaseDateTime()));
            }
            case "LastDecreaseDateTime": {
                return Optional.of(clazz.cast(this.lastDecreaseDateTime()));
            }
            case "NumberOfDecreasesToday": {
                return Optional.of(clazz.cast(this.numberOfDecreasesToday()));
            }
            case "ReadCapacityUnits": {
                return Optional.of(clazz.cast(this.readCapacityUnits()));
            }
            case "WriteCapacityUnits": {
                return Optional.of(clazz.cast(this.writeCapacityUnits()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisionedThroughputDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant lastIncreaseDateTime;
        private Instant lastDecreaseDateTime;
        private Long numberOfDecreasesToday;
        private Long readCapacityUnits;
        private Long writeCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisionedThroughputDescription model) {
            this.lastIncreaseDateTime(model.lastIncreaseDateTime);
            this.lastDecreaseDateTime(model.lastDecreaseDateTime);
            this.numberOfDecreasesToday(model.numberOfDecreasesToday);
            this.readCapacityUnits(model.readCapacityUnits);
            this.writeCapacityUnits(model.writeCapacityUnits);
        }

        public final Instant getLastIncreaseDateTime() {
            return this.lastIncreaseDateTime;
        }

        @Override
        public final Builder lastIncreaseDateTime(Instant lastIncreaseDateTime) {
            this.lastIncreaseDateTime = lastIncreaseDateTime;
            return this;
        }

        public final void setLastIncreaseDateTime(Instant lastIncreaseDateTime) {
            this.lastIncreaseDateTime = lastIncreaseDateTime;
        }

        public final Instant getLastDecreaseDateTime() {
            return this.lastDecreaseDateTime;
        }

        @Override
        public final Builder lastDecreaseDateTime(Instant lastDecreaseDateTime) {
            this.lastDecreaseDateTime = lastDecreaseDateTime;
            return this;
        }

        public final void setLastDecreaseDateTime(Instant lastDecreaseDateTime) {
            this.lastDecreaseDateTime = lastDecreaseDateTime;
        }

        public final Long getNumberOfDecreasesToday() {
            return this.numberOfDecreasesToday;
        }

        @Override
        public final Builder numberOfDecreasesToday(Long numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
            return this;
        }

        public final void setNumberOfDecreasesToday(Long numberOfDecreasesToday) {
            this.numberOfDecreasesToday = numberOfDecreasesToday;
        }

        public final Long getReadCapacityUnits() {
            return this.readCapacityUnits;
        }

        @Override
        public final Builder readCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
            return this;
        }

        public final void setReadCapacityUnits(Long readCapacityUnits) {
            this.readCapacityUnits = readCapacityUnits;
        }

        public final Long getWriteCapacityUnits() {
            return this.writeCapacityUnits;
        }

        @Override
        public final Builder writeCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
            return this;
        }

        public final void setWriteCapacityUnits(Long writeCapacityUnits) {
            this.writeCapacityUnits = writeCapacityUnits;
        }

        public ProvisionedThroughputDescription build() {
            return new ProvisionedThroughputDescription(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisionedThroughputDescription> {
        public Builder lastIncreaseDateTime(Instant var1);

        public Builder lastDecreaseDateTime(Instant var1);

        public Builder numberOfDecreasesToday(Long var1);

        public Builder readCapacityUnits(Long var1);

        public Builder writeCapacityUnits(Long var1);
    }
}

