/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import java.util.Map;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemRequest;

@SdkInternalApi
public class UpdateItemRequestModelMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<Map> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final MarshallingInfo<Map> ATTRIBUTEUPDATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeUpdates").build();
    private static final MarshallingInfo<Map> EXPECTED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Expected").build();
    private static final MarshallingInfo<String> CONDITIONALOPERATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionalOperator").build();
    private static final MarshallingInfo<String> RETURNVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnValues").build();
    private static final MarshallingInfo<String> RETURNCONSUMEDCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnConsumedCapacity").build();
    private static final MarshallingInfo<String> RETURNITEMCOLLECTIONMETRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReturnItemCollectionMetrics").build();
    private static final MarshallingInfo<String> UPDATEEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateExpression").build();
    private static final MarshallingInfo<String> CONDITIONEXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConditionExpression").build();
    private static final MarshallingInfo<Map> EXPRESSIONATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionAttributeNames").build();
    private static final MarshallingInfo<Map> EXPRESSIONATTRIBUTEVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpressionAttributeValues").build();
    private static final UpdateItemRequestModelMarshaller INSTANCE = new UpdateItemRequestModelMarshaller();

    public static UpdateItemRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateItemRequest updateItemRequest, ProtocolMarshaller protocolMarshaller) {
        if (updateItemRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)updateItemRequest.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(updateItemRequest.key(), KEY_BINDING);
            protocolMarshaller.marshall(updateItemRequest.attributeUpdates(), ATTRIBUTEUPDATES_BINDING);
            protocolMarshaller.marshall(updateItemRequest.expected(), EXPECTED_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.conditionalOperator(), CONDITIONALOPERATOR_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.returnValues(), RETURNVALUES_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.returnConsumedCapacity(), RETURNCONSUMEDCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.returnItemCollectionMetrics(), RETURNITEMCOLLECTIONMETRICS_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.updateExpression(), UPDATEEXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)updateItemRequest.conditionExpression(), CONDITIONEXPRESSION_BINDING);
            protocolMarshaller.marshall(updateItemRequest.expressionAttributeNames(), EXPRESSIONATTRIBUTENAMES_BINDING);
            protocolMarshaller.marshall(updateItemRequest.expressionAttributeValues(), EXPRESSIONATTRIBUTEVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

