/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.transform.AttributeValueUnmarshaller;

public class KeysAndAttributesUnmarshaller
implements Unmarshaller<KeysAndAttributes, JsonUnmarshallerContext> {
    private static final KeysAndAttributesUnmarshaller INSTANCE = new KeysAndAttributesUnmarshaller();

    public KeysAndAttributes unmarshall(JsonUnmarshallerContext context) throws Exception {
        KeysAndAttributes.Builder keysAndAttributesBuilder = KeysAndAttributes.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Keys", targetDepth)) {
                    context.nextToken();
                    keysAndAttributesBuilder.keys(new ListUnmarshaller((Unmarshaller)new MapUnmarshaller(context.getUnmarshaller(String.class), (Unmarshaller)AttributeValueUnmarshaller.getInstance())).unmarshall(context));
                }
                if (context.testExpression("AttributesToGet", targetDepth)) {
                    context.nextToken();
                    keysAndAttributesBuilder.attributesToGet(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("ConsistentRead", targetDepth)) {
                    context.nextToken();
                    keysAndAttributesBuilder.consistentRead((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("ProjectionExpression", targetDepth)) {
                    context.nextToken();
                    keysAndAttributesBuilder.projectionExpression((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ExpressionAttributeNames", targetDepth)) {
                    context.nextToken();
                    keysAndAttributesBuilder.expressionAttributeNames(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (KeysAndAttributes)keysAndAttributesBuilder.build();
    }

    public static KeysAndAttributesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

